/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.smelting;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class SmeltingRecipeWrapper
implements IRecipeWrapper {
    protected final List<ItemStack> inputs;
    protected final List<FluidStack> outputs;
    protected final int temperature;
    protected final List<FluidStack> fuels;

    public SmeltingRecipeWrapper(MeltingRecipe recipe) {
        this.inputs = recipe.input.getInputs();
        this.outputs = ImmutableList.of((Object)recipe.getResult());
        this.temperature = recipe.getTemperature();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FluidStack fs : TinkerRegistry.getSmelteryFuels()) {
            if (fs.getFluid().getTemperature(fs) < this.temperature) continue;
            fs = fs.copy();
            fs.amount = 1000;
            builder.add((Object)fs);
        }
        this.fuels = builder.build();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(FluidStack.class, this.outputs);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String tmpStr = String.valueOf(this.temperature) + "\u00b0";
        int x = 80 - minecraft.field_71466_p.func_78256_a(tmpStr) / 2;
        minecraft.field_71466_p.func_78276_b(tmpStr, x, 10, Color.gray.getRGB());
    }
}

