/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class FluidUpdatePacket
extends AbstractPacketThreadsafe {
    public BlockPos pos;
    public FluidStack fluid;

    public FluidUpdatePacket() {
    }

    public FluidUpdatePacket(BlockPos pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (te instanceof TileTank) {
            ((TileTank)te).updateFluidTo(this.fluid);
        } else if (te instanceof TileCasting) {
            ((TileCasting)te).updateFluidTo(this.fluid);
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Serverside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(tag);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }
}

