/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.eventbus.Subscribe;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.Shard;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.ToolEvents;
import slimeknights.tconstruct.tools.TraitEvents;
import slimeknights.tconstruct.tools.common.RepairRecipe;
import slimeknights.tconstruct.tools.common.TableRecipeFactory;
import slimeknights.tconstruct.tools.common.block.BlockToolForge;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.common.item.ItemBlockTable;
import slimeknights.tconstruct.tools.common.item.SharpeningKit;
import slimeknights.tconstruct.tools.common.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.common.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.common.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.common.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.common.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.common.tileentity.TileToolForge;
import slimeknights.tconstruct.tools.common.tileentity.TileToolStation;
import slimeknights.tconstruct.tools.ranged.item.BoltCore;

@Pulse(id="TinkerTools", description="All the tools and everything related to it.")
public class TinkerTools
extends AbstractToolPulse {
    public static final String PulseId = "TinkerTools";
    static final Logger log = Util.getLogger("TinkerTools");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ToolClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockToolTable toolTables;
    public static BlockToolForge toolForge;
    public static Pattern pattern;
    public static Shard shard;
    public static SharpeningKit sharpeningKit;
    public static ToolPart pickHead;
    public static ToolPart shovelHead;
    public static ToolPart axeHead;
    public static ToolPart broadAxeHead;
    public static ToolPart swordBlade;
    public static ToolPart largeSwordBlade;
    public static ToolPart hammerHead;
    public static ToolPart excavatorHead;
    public static ToolPart scytheHead;
    public static ToolPart panHead;
    public static ToolPart signHead;
    public static ToolPart toolRod;
    public static ToolPart toughToolRod;
    public static ToolPart binding;
    public static ToolPart toughBinding;
    public static ToolPart wideGuard;
    public static ToolPart handGuard;
    public static ToolPart crossGuard;
    public static ToolPart largePlate;
    public static ToolPart knifeBlade;
    public static ToolPart bowLimb;
    public static ToolPart bowString;
    public static ToolPart arrowHead;
    public static ToolPart arrowShaft;
    public static ToolPart fletching;
    public static BoltCore boltCore;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        toolTables = TinkerTools.registerBlock((IForgeRegistry<Block>)registry, new BlockToolTable(), "tooltables");
        toolForge = TinkerTools.registerBlock((IForgeRegistry<Block>)registry, new BlockToolForge(), "toolforge");
        TinkerTools.registerTE(TileTable.class, "table");
        TinkerTools.registerTE(TileCraftingStation.class, "craftingstation");
        TinkerTools.registerTE(TileStencilTable.class, "stenciltable");
        TinkerTools.registerTE(TilePartBuilder.class, "partbuilder");
        TinkerTools.registerTE(TilePatternChest.class, "patternchest");
        TinkerTools.registerTE(TilePartChest.class, "partchest");
        TinkerTools.registerTE(TileToolStation.class, "toolstation");
        TinkerTools.registerTE(TileToolForge.class, "toolforge");
    }

    @Override
    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        pattern = TinkerTools.registerItem((IForgeRegistry<Item>)registry, new Pattern(), "pattern");
        shard = TinkerTools.registerItem((IForgeRegistry<Item>)registry, new Shard(), "shard");
        sharpeningKit = (SharpeningKit)this.registerToolPart((IForgeRegistry<Item>)registry, new SharpeningKit(), "sharpening_kit");
        sharpeningKit.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        TinkerRegistry.registerToolPart(sharpeningKit);
        TinkerRegistry.registerToolPart(shard);
        super.registerItems(event);
        toolTables = (BlockToolTable)TinkerTools.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockTable((Block)toolTables), BlockToolTable.TABLES);
        toolForge = (BlockToolForge)TinkerTools.registerItemBlock((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockTable((Block)toolForge));
        TinkerRegistry.setShardItem(shard);
        TinkerRegistry.registerStencilTableCrafting(Pattern.setTagForPart(new ItemStack((Item)pattern), sharpeningKit));
        TinkerRegistry.registerStencilTableCrafting(Pattern.setTagForPart(new ItemStack((Item)pattern), shard));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("indestructible"), IndestructibleEntityItem.class, (String)"Indestructible Item", (int)0, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new RepairRecipe());
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Override
    protected void registerToolParts(IForgeRegistry<Item> registry) {
        pickHead = this.registerToolPart(registry, new ToolPart(288), "pick_head");
        shovelHead = this.registerToolPart(registry, new ToolPart(288), "shovel_head");
        axeHead = this.registerToolPart(registry, new ToolPart(288), "axe_head");
        broadAxeHead = this.registerToolPart(registry, new ToolPart(1152), "broad_axe_head");
        swordBlade = this.registerToolPart(registry, new ToolPart(288), "sword_blade");
        largeSwordBlade = this.registerToolPart(registry, new ToolPart(1152), "large_sword_blade");
        hammerHead = this.registerToolPart(registry, new ToolPart(1152), "hammer_head");
        excavatorHead = this.registerToolPart(registry, new ToolPart(1152), "excavator_head");
        scytheHead = this.registerToolPart(registry, new ToolPart(1152), "scythe_head");
        panHead = this.registerToolPart(registry, new ToolPart(432), "pan_head");
        signHead = this.registerToolPart(registry, new ToolPart(432), "sign_head");
        toolRod = this.registerToolPart(registry, new ToolPart(144), "tool_rod");
        toughToolRod = this.registerToolPart(registry, new ToolPart(432), "tough_tool_rod");
        binding = this.registerToolPart(registry, new ToolPart(144), "binding");
        toughBinding = this.registerToolPart(registry, new ToolPart(432), "tough_binding");
        wideGuard = this.registerToolPart(registry, new ToolPart(144), "wide_guard");
        handGuard = this.registerToolPart(registry, new ToolPart(144), "hand_guard");
        crossGuard = this.registerToolPart(registry, new ToolPart(144), "cross_guard");
        largePlate = this.registerToolPart(registry, new ToolPart(1152), "large_plate");
        knifeBlade = this.registerToolPart(registry, new ToolPart(144), "knife_blade");
        bowLimb = this.registerToolPart(registry, new ToolPart(432), "bow_limb");
        bowString = this.registerToolPart(registry, new ToolPart(144), "bow_string");
        arrowHead = this.registerToolPart(registry, new ToolPart(288), "arrow_head");
        arrowShaft = this.registerToolPart(registry, new ToolPart(288), "arrow_shaft");
        fletching = this.registerToolPart(registry, new ToolPart(288), "fletching");
        boltCore = (BoltCore)this.registerToolPart(registry, new BoltCore(288), "bolt_core", null);
        toolparts.remove(boltCore);
    }

    @Override
    @Subscribe
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerSmeltingRecipes();
        proxy.init();
    }

    protected void registerSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)TinkerCommons.oreArdite, (ItemStack)TinkerCommons.ingotArdite, (float)1.0f);
        GameRegistry.addSmelting((ItemStack)TinkerCommons.oreCobalt, (ItemStack)TinkerCommons.ingotCobalt, (float)1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudGreen, TinkerCommons.matSlimeCrystalGreen, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudBlue, TinkerCommons.matSlimeCrystalBlue, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudMagma, TinkerCommons.matSlimeCrystalMagma, 0.0f);
    }

    public static void registerToolForgeBlock(IForgeRegistry<IRecipe> registry, String oredict) {
        if (toolForge != null) {
            TinkerTools.toolForge.baseBlocks.add(oredict);
            TinkerTools.registerToolForgeRecipe(registry, oredict);
        }
    }

    private static void registerToolForgeRecipe(IForgeRegistry<IRecipe> registry, String oredict) {
        BlockSeared brick = TinkerSmeltery.searedBlock;
        if (brick == null) {
            brick = Blocks.field_150417_aV;
        }
        TableRecipeFactory.TableRecipe recipe = new TableRecipeFactory.TableRecipe(Util.getResource("tool_forge"), (Ingredient)new OreIngredient(oredict), new ItemStack((Block)toolForge), CraftingHelper.parseShaped((Object[])new Object[]{"BBB", "MTM", "M M", Character.valueOf('B'), brick, Character.valueOf('M'), oredict, Character.valueOf('T'), new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.ToolStation.meta)}));
        recipe.setRegistryName(Util.getResource("tools/forge/" + oredict.toLowerCase(Locale.US)));
        registry.register((IForgeRegistryEntry)recipe);
    }

    @Override
    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        proxy.postInit();
    }

    @Override
    protected void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)IndestructibleEntityItem.EventHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new TraitEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ToolEvents());
        MinecraftForge.EVENT_BUS.register((Object)DualToolHarvestUtils.INSTANCE);
    }
}

