/*
 * Decompiled with CFR 0.152.
 */
package net.rim.device.api.crypto.certificate;

import net.rim.device.api.crypto.CryptoTokenException;
import net.rim.device.api.crypto.CryptoUnsupportedOperationException;
import net.rim.device.api.crypto.DecodeException;
import net.rim.device.api.crypto.InvalidCryptoSystemException;
import net.rim.device.api.crypto.InvalidSignatureEncodingException;
import net.rim.device.api.crypto.NoSuchAlgorithmException;
import net.rim.device.api.crypto.PublicKey;
import net.rim.device.api.crypto.certificate.CertificateChainTooLongException;
import net.rim.device.api.crypto.certificate.CertificateDisplayField;
import net.rim.device.api.crypto.certificate.CertificateExtension;
import net.rim.device.api.crypto.certificate.CertificateStatus;
import net.rim.device.api.crypto.certificate.CertificateVerificationException;
import net.rim.device.api.crypto.certificate.DistinguishedName;
import net.rim.device.api.crypto.certificate.NoIssuerFoundException;
import net.rim.device.api.crypto.keystore.BackwardStatusException;
import net.rim.device.api.crypto.keystore.InvalidTimeException;
import net.rim.device.api.crypto.keystore.KeyStore;
import net.rim.device.api.crypto.keystore.KeyStoreCancelException;
import net.rim.device.api.crypto.oid.OID;
import net.rim.device.api.util.Persistable;

public interface Certificate
extends Persistable {
    public static final long EMAIL_ADDRESSES = -7850001002262082664L;
    public static final long PUBLIC_KEY_ALGORITHM_INFORMATION = -3174973482910568002L;
    public static final long DISPLAY_ROOT = -334528756150594391L;
    public static final long DISPLAY_CA = -2021910959928808912L;
    public static final long PROMPT_TO_TRUST_ON_IMPORT = -1188891808812199856L;
    public static final long IS_END_ENTITY = -7341435958452683242L;
    public static final long SUMMARY_TEXT = -5753772986264564736L;

    public void verify(PublicKey var1) throws CertificateVerificationException, DecodeException, InvalidSignatureEncodingException, NoSuchAlgorithmException, CryptoTokenException, CryptoUnsupportedOperationException;

    public void verify(KeyStore var1) throws CertificateVerificationException, DecodeException, InvalidSignatureEncodingException, NoSuchAlgorithmException, NoIssuerFoundException, CryptoTokenException, CryptoUnsupportedOperationException;

    public boolean isRoot();

    public boolean isCA();

    public void verify() throws CertificateVerificationException, DecodeException, InvalidSignatureEncodingException, NoSuchAlgorithmException, CryptoTokenException, CryptoUnsupportedOperationException;

    public void checkCertificateChain(int var1, Certificate[] var2) throws CertificateChainTooLongException, CertificateVerificationException;

    public PublicKey getPublicKey() throws InvalidCryptoSystemException;

    public String getPublicKeyAlgorithm();

    public String getSignatureAlgorithm();

    public DistinguishedName getIssuer();

    public DistinguishedName getSubject();

    public CertificateStatus getStatus();

    public void setStatus(CertificateStatus var1) throws KeyStoreCancelException, InvalidTimeException, BackwardStatusException;

    public boolean isValid();

    public boolean isValid(long var1);

    public long getNotBefore();

    public long getNotAfter();

    public CertificateExtension getExtension(OID var1);

    public CertificateExtension[] getExtensions();

    public CertificateExtension[] getExtensions(boolean var1);

    public String getType();

    public int getVersion();

    public byte[] getSerialNumber();

    public byte[] getEncoding();

    public byte[] getEncoding(int var1);

    public String getSubjectFriendlyName();

    public int queryKeyUsage(long var1);

    public CertificateDisplayField[] getCustomDisplayFields();

    public Object getInformation(long var1, Object var3, Object var4);
}

