/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class DoubleByteDecoder
extends CharsetDecoder {
    private short[] index1;
    private String[] index2;
    protected int start;
    protected int end;
    protected static final char REPLACE_CHAR = '\ufffd';
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !DoubleByteDecoder.class.desiredAssertionStatus();
    }

    protected char decodeSingle(int n) {
        if (n >= 0) {
            return (char)n;
        }
        return '\ufffd';
    }

    protected char decodeDouble(int n, int n2) {
        if (n < 0 || n > this.index1.length || n2 < this.start || n2 > this.end) {
            return '\ufffd';
        }
        int n3 = (this.index1[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
        return this.index2[this.index1[n] >> 4].charAt(n3);
    }

    protected DoubleByteDecoder(Charset charset, short[] sArray, String[] stringArray, int n, int n2) {
        super(charset, 0.5f, 1.0f);
        this.index1 = sArray;
        this.index2 = stringArray;
        this.start = n;
        this.end = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block12: {
            CoderResult coderResult2;
            block11: {
                CoderResult coderResult3;
                block10: {
                    CoderResult coderResult4;
                    block9: {
                        byte[] byArray = byteBuffer.array();
                        n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
                        if (!$assertionsDisabled && n2 > n3) {
                            throw new AssertionError();
                        }
                        char[] cArray = charBuffer.array();
                        n = charBuffer.arrayOffset() + charBuffer.position();
                        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                        if (!$assertionsDisabled && n > n4) {
                            throw new AssertionError();
                        }
                        n = n <= n4 ? n : n4;
                        try {
                            int n5;
                            for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; n2 += n5) {
                                int n6 = byArray[n2];
                                n5 = 1;
                                char c = this.decodeSingle(n6);
                                if (c == '\ufffd') {
                                    n6 &= 0xFF;
                                    if (n3 - n2 < 2) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        Object var15_17 = null;
                                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                                        break block9;
                                    }
                                    int n7 = byArray[n2 + 1] & 0xFF;
                                    c = this.decodeDouble(n6, n7);
                                    if (c == '\ufffd') {
                                        coderResult3 = CoderResult.unmappableForLength(1);
                                        break block10;
                                    }
                                    n5 = 2;
                                }
                                if (n4 - n < 1) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block11;
                                }
                                cArray[n++] = c;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var15_21 = null;
                            byteBuffer.position(n2 - byteBuffer.arrayOffset());
                            charBuffer.position(n - charBuffer.arrayOffset());
                            throw throwable;
                        }
                    }
                    charBuffer.position(n - charBuffer.arrayOffset());
                    return coderResult4;
                }
                Object var15_18 = null;
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n - charBuffer.arrayOffset());
                return coderResult3;
            }
            Object var15_19 = null;
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n - charBuffer.arrayOffset());
            return coderResult2;
        }
        Object var15_20 = null;
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        charBuffer.position(n - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        try {
            while (byteBuffer.hasRemaining()) {
                int n3 = byteBuffer.get();
                n2 = 1;
                char c = this.decodeSingle(n3);
                if (c == '\ufffd') {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n4 = byteBuffer.get() & 0xFF;
                    n2 = 2;
                    c = this.decodeDouble(n3 &= 0xFF, n4);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += n2;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

