/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = 0;
    protected int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    public void close() {
        this.buf = null;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.count - this.pos > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if ((long)this.pos + l > (long)this.count) {
                l = this.count - this.pos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
    }

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n;
        this.count = Math.min(n + n2, cArray.length);
        this.markedPos = n;
    }
}

