/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class Win32FileSystem
extends FileSystem {
    private final char slash;
    private final char altSlash;
    private final char semicolon;
    private static String[] driveDirCache;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache prefixCache = new ExpiringCache();
    static final /* synthetic */ boolean $assertionsDisabled;

    public char getPathSeparator() {
        return this.semicolon;
    }

    public char getSeparator() {
        return this.slash;
    }

    private static native int listRoots0();

    static {
        $assertionsDisabled = !Win32FileSystem.class.desiredAssertionStatus();
        driveDirCache = new String[26];
        Win32FileSystem.initIDs();
    }

    public Win32FileSystem() {
        this.slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
        this.semicolon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
    }

    private static native void initIDs();

    private static int driveIndex(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        return -1;
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    public File[] listRoots() {
        int n = Win32FileSystem.listRoots0();
        int n2 = 0;
        for (int i = 0; i < 26; ++i) {
            if ((n >> i & 1) == 0) continue;
            if (!this.access((char)(65 + i) + ":" + this.slash)) {
                n &= ~(1 << i);
                continue;
            }
            ++n2;
        }
        File[] fileArray = new File[n2];
        int n3 = 0;
        char c = this.slash;
        for (int i = 0; i < 26; ++i) {
            if ((n >> i & 1) == 0) continue;
            fileArray[n3++] = new File((char)(65 + i) + ":" + c);
        }
        return fileArray;
    }

    public native int getBooleanAttributes(File var1);

    public int hashCode(File file) {
        return file.getPath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createDirectory(File var1);

    public boolean delete(File file) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public boolean isAbsolute(File file) {
        int n = file.getPrefixLength();
        return n == 2 && file.getPath().charAt(0) == this.slash || n == 3;
    }

    public native boolean setReadOnly(File var1);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean checkAccess(File var1, boolean var2);

    public String getDefaultParent() {
        return "" + this.slash;
    }

    private String getUserPath() {
        return this.normalize(System.getProperty("user.dir"));
    }

    private String getDriveDirectory(char c) {
        int n = Win32FileSystem.driveIndex(c);
        if (n < 0) {
            return null;
        }
        String string = driveDirCache[n];
        if (string != null) {
            return string;
        }
        Win32FileSystem.driveDirCache[n] = string = this.getDriveDirectory(n + 1);
        return string;
    }

    native String getDriveDirectory(int var1);

    public int prefixLength(String string) {
        char c;
        char c2 = this.slash;
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c3 = string.charAt(0);
        char c4 = c = n > 1 ? string.charAt(1) : (char)'\u0000';
        if (c3 == c2) {
            if (c == c2) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c3) && c == ':') {
            if (n > 2 && string.charAt(2) == c2) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    private boolean access(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public native boolean createFileExclusively(String var1) throws IOException;

    public int compare(File file, File file2) {
        return file.getPath().compareToIgnoreCase(file2.getPath());
    }

    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.prefixCache.clear();
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    public String resolve(File file) {
        String string = file.getPath();
        int n = file.getPrefixLength();
        if (n == 2 && string.charAt(0) == this.slash) {
            return string;
        }
        if (n == 3) {
            return string;
        }
        if (n == 0) {
            return this.getUserPath() + this.slashify(string);
        }
        if (n == 1) {
            String string2 = this.getUserPath();
            String string3 = this.getDrive(string2);
            if (string3 != null) {
                return string3 + string;
            }
            return string2 + string;
        }
        if (n == 2) {
            String string4 = this.getUserPath();
            String string5 = this.getDrive(string4);
            if (string5 != null && string.startsWith(string5)) {
                return string4 + this.slashify(string.substring(2));
            }
            char c = string.charAt(0);
            String string6 = this.getDriveDirectory(c);
            if (string6 != null) {
                String string7 = "" + c + ':' + string6 + this.slashify(string.substring(2));
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(string7);
                    }
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Cannot resolve path " + string);
                }
                return string7;
            }
            return c + ":" + this.slashify(string.substring(2));
        }
        throw new InternalError("Unresolvable path: " + string);
    }

    public native String[] list(File var1);

    public String canonicalize(String string) throws IOException {
        if (!useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (useCanonPrefixCache && (string3 = Win32FileSystem.parentOrNull(string)) != null && (string4 = this.prefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = this.canonicalizeWithPrefix(string4, (String)object);
                this.cache.put(string3 + File.separatorChar + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (useCanonPrefixCache && string3 != null && (string4 = Win32FileSystem.parentOrNull(string2)) != null && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.prefixCache.put(string3, string4);
                }
            }
        }
        if (!$assertionsDisabled && !this.canonicalize0(string).equalsIgnoreCase(string2)) {
            throw new AssertionError();
        }
        return string2;
    }

    protected native String canonicalize0(String var1) throws IOException;

    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.length() > 2 && string2.charAt(2) == ':') {
            if ((string2 = string2.substring(1)).length() > 3 && string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private String getDrive(String string) {
        int n = this.prefixLength(string);
        return n == 3 ? string.substring(0, 2) : null;
    }

    public String normalize(String string) {
        int n = string.length();
        char c = this.slash;
        char c2 = this.altSlash;
        char c3 = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c4 = string.charAt(i);
            if (c4 == c2) {
                return this.normalize(string, n, c3 == c ? i - 1 : i);
            }
            if (c4 == c && c3 == c && i > 1) {
                return this.normalize(string, n, i - 1);
            }
            if (c4 == ':' && i > 1) {
                return this.normalize(string, n, 0);
            }
            c3 = c4;
        }
        if (c3 == c) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    static String parentOrNull(String string) {
        int n;
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        char c2 = '/';
        int n2 = 0;
        int n3 = 0;
        for (int i = n = string.length() - 1; i > 0; --i) {
            char c3 = string.charAt(i);
            if (c3 == '.') {
                if (++n2 >= 2) {
                    return null;
                }
                if (n3 != 0) continue;
                return null;
            }
            if (c3 == c) {
                if (n2 == 1 && n3 == 0) {
                    return null;
                }
                if (i == 0 || i >= n - 1 || string.charAt(i - 1) == c || string.charAt(i - 1) == c2) {
                    return null;
                }
                return string.substring(0, i);
            }
            if (c3 == c2) {
                return null;
            }
            if (c3 == '*' || c3 == '?') {
                return null;
            }
            ++n3;
            n2 = 0;
        }
        return null;
    }

    private String slashify(String string) {
        if (string.length() > 0 && string.charAt(0) != this.slash) {
            return this.slash + string;
        }
        return string;
    }

    private String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        if (n2 < 3) {
            n2 = 0;
        }
        char c = this.slash;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (n2 == 0) {
            n3 = this.normalizePrefix(string, n, stringBuffer);
        } else {
            n3 = n2;
            stringBuffer.append(string.substring(0, n2));
        }
        while (n3 < n) {
            char c2;
            if (this.isSlash(c2 = string.charAt(n3++))) {
                while (n3 < n && this.isSlash(string.charAt(n3))) {
                    ++n3;
                }
                if (n3 == n) {
                    int n4 = stringBuffer.length();
                    if (n4 == 2 && stringBuffer.charAt(1) == ':') {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 != 1 || !this.isSlash(stringBuffer.charAt(0))) break;
                    stringBuffer.append(c);
                    break;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private int normalizePrefix(String string, int n, StringBuffer stringBuffer) {
        char c;
        int n2;
        for (n2 = 0; n2 < n && this.isSlash(string.charAt(n2)); ++n2) {
        }
        if (n - n2 >= 2 && this.isLetter(c = string.charAt(n2)) && string.charAt(n2 + 1) == ':') {
            stringBuffer.append(c);
            stringBuffer.append(':');
            n2 += 2;
        } else {
            n2 = 0;
            if (n >= 2 && this.isSlash(string.charAt(0)) && this.isSlash(string.charAt(1))) {
                n2 = 1;
                stringBuffer.append(this.slash);
            }
        }
        return n2;
    }

    protected String canonicalizeWithPrefix(String string, String string2) throws IOException {
        return this.canonicalizeWithPrefix0(string, string + File.separatorChar + string2);
    }

    protected native String canonicalizeWithPrefix0(String var1, String var2) throws IOException;

    public String resolve(String string, String string2) {
        String string3;
        char c = this.slash;
        int n = string.length();
        if (n == 0) {
            return string2;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return string;
        }
        String string4 = string2;
        if (n2 > 1 && string4.charAt(0) == c) {
            string4 = string4.charAt(1) == c ? string4.substring(2) : string4.substring(1);
        }
        if ((string3 = string).charAt(n - 1) == c) {
            string3 = string3.substring(0, n - 1);
        }
        return string3 + this.slashify(string4);
    }
}

