/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = Class.getPrimitiveClass("long");
    private static ThreadLocal perThreadBuffer = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new char[20];
        }
    };
    private long value;
    private static final long serialVersionUID = 4290774380558885855L;

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public Long(long l) {
        this.value = l;
    }

    private static int getChars(long l, char[] cArray) {
        int n;
        int n2;
        int n3 = 20;
        int n4 = 0;
        if (l < 0L) {
            n4 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n2 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n3] = Integer.DigitOnes[n2];
            cArray[--n3] = Integer.DigitTens[n2];
        }
        int n5 = (int)l;
        while (n5 >= 65536) {
            n = n5 / 100;
            n2 = n5 - ((n << 6) + (n << 5) + (n << 2));
            n5 = n;
            cArray[--n3] = Integer.DigitOnes[n2];
            cArray[--n3] = Integer.DigitTens[n2];
        }
        do {
            n = n5 * 52429 >>> 19;
            n2 = n5 - ((n << 3) + (n << 1));
            cArray[--n3] = Integer.digits[n2];
        } while ((n5 = n) != 0);
        if (n4 != 0) {
            cArray[--n3] = n4;
        }
        return n3;
    }

    public int compareTo(Long l) {
        long l2 = this.value;
        long l3 = l.value;
        return l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Long)object);
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.value == (Long)object;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static String toString(long l) {
        if (l == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        char[] cArray = (char[])perThreadBuffer.get();
        int n = Long.getChars(l, cArray);
        return new String(cArray, n, 20 - n);
    }

    public static String toString(long l, int n) {
        boolean bl;
        if (n < 2 || n > 36) {
            n = 10;
        }
        if (n == 10) {
            return Long.toString(l);
        }
        char[] cArray = new char[65];
        int n2 = 64;
        boolean bl2 = bl = l < 0L;
        if (!bl) {
            l = -l;
        }
        while (l <= (long)(-n)) {
            cArray[n2--] = Integer.digits[(int)(-(l % (long)n))];
            l /= (long)n;
        }
        cArray[n2] = Integer.digits[(int)(-l)];
        if (bl) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, 65 - n2);
    }

    private static String toUnsignedString(long l, int n) {
        char[] cArray = new char[64];
        int n2 = 64;
        int n3 = 1 << n;
        long l2 = n3 - 1;
        do {
            cArray[--n2] = Integer.digits[(int)(l & l2)];
        } while ((l >>>= n) != 0L);
        return new String(cArray, n2, 64 - n2);
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public Long(String string) throws NumberFormatException {
        this.value = Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        long l = 0L;
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 0) {
            int n4;
            long l2;
            if (string.charAt(0) == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n2;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / (long)n;
            if (n2 < n3) {
                if ((n4 = Character.digit(string.charAt(n2++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                l = -n4;
            }
            while (n2 < n3) {
                if ((n4 = Character.digit(string.charAt(n2++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (l < l3) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((l *= (long)n) < l2 + (long)n4) {
                    throw NumberFormatException.forInputString(string);
                }
                l -= (long)n4;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        if (bl) {
            if (n2 > 1) {
                return l;
            }
            throw NumberFormatException.forInputString(string);
        }
        return -l;
    }

    static void appendTo(long l, StringBuffer stringBuffer) {
        if (l == Long.MIN_VALUE) {
            stringBuffer.append("-9223372036854775808");
            return;
        }
        char[] cArray = (char[])perThreadBuffer.get();
        int n = Long.getChars(l, cArray);
        stringBuffer.append(cArray, n, 20 - n);
    }

    public static Long decode(String string) throws NumberFormatException {
        Long l;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            l = Long.valueOf(string.substring(n2), n);
            l = bl ? new Long(-l.longValue()) : l;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? new String("-" + string.substring(n2)) : string.substring(n2);
            l = Long.valueOf(string2, n);
        }
        return l;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return new Long(Long.parseLong(string, 10));
    }

    public static Long valueOf(String string, int n) throws NumberFormatException {
        return new Long(Long.parseLong(string, n));
    }

    public static Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        return l2 == null ? new Long(l) : l2;
    }

    public static Long getLong(String string, Long l) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Long.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }
}

