/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import sun.security.util.SecurityConstants;

public class SecurityManager {
    protected boolean inCheck;
    private boolean initialized = false;
    private static ThreadGroup rootGroup = SecurityManager.getRootGroup();
    private static boolean packageAccessValid = false;
    private static String[] packageAccess = new String[0];
    private static boolean packageDefinitionValid = false;
    private static String[] packageDefinition = new String[0];

    protected int classLoaderDepth() {
        int n = this.classLoaderDepth0();
        if (n != -1) {
            n = this.hasAllPermission() ? -1 : --n;
        }
        return n;
    }

    private native int classLoaderDepth0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityManager() {
        Class clazz = SecurityManager.class;
        synchronized (clazz) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            this.initialized = true;
        }
    }

    public void checkAwtEventQueueAccess() {
        this.checkPermission(SecurityConstants.CHECK_AWT_EVENTQUEUE_PERMISSION);
    }

    public void checkCreateClassLoader() {
        this.checkPermission(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkSystemClipboardAccess() {
        this.checkPermission(SecurityConstants.ACCESS_CLIPBOARD_PERMISSION);
    }

    public boolean getInCheck() {
        return this.inCheck;
    }

    private boolean hasAllPermission() {
        try {
            this.checkPermission(SecurityConstants.ALL_PERMISSION);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected boolean inClassLoader() {
        return this.currentClassLoader() != null;
    }

    public void checkExit(int n) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkListen(int n) {
        if (n == 0) {
            this.checkPermission(SecurityConstants.LOCAL_LISTEN_PERMISSION);
        } else {
            this.checkPermission(new SocketPermission("localhost:" + n, "listen"));
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    protected Class currentLoadedClass() {
        Class clazz = this.currentLoadedClass0();
        if (clazz != null && this.hasAllPermission()) {
            clazz = null;
        }
        return clazz;
    }

    private native Class currentLoadedClass0();

    protected native Class[] getClassContext();

    public void checkMemberAccess(Class clazz, int n) {
        Class[] classArray;
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (n != 0 && ((classArray = this.getClassContext()).length < 4 || classArray[3].getClassLoader() != clazz.getClassLoader())) {
            this.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
    }

    protected ClassLoader currentClassLoader() {
        ClassLoader classLoader = this.currentClassLoader0();
        if (classLoader != null && this.hasAllPermission()) {
            classLoader = null;
        }
        return classLoader;
    }

    private native ClassLoader currentClassLoader0();

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        try {
            this.checkPermission(SecurityConstants.TOPLEVEL_WINDOW_PERMISSION);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected native int classDepth(String var1);

    public void checkDelete(String string) {
        this.checkPermission(new FilePermission(string, "delete"));
    }

    public void checkExec(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            this.checkPermission(new FilePermission(string, "execute"));
        } else {
            this.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public void checkLink(String string) {
        if (string == null) {
            throw new NullPointerException("library can't be null");
        }
        this.checkPermission(new RuntimePermission("loadLibrary." + string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageAccess(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        String[] stringArray = packageAccess;
        synchronized (packageAccess) {
            if (!packageAccessValid) {
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("package.access");
                    }
                });
                packageAccess = SecurityManager.getPackages(string2);
                packageAccessValid = true;
            }
            for (int i = 0; i < packageAccess.length; ++i) {
                if (!string.startsWith(packageAccess[i]) && !packageAccess[i].equals(string + ".")) continue;
                this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPackageDefinition(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        String[] stringArray = packageDefinition;
        synchronized (packageDefinition) {
            if (!packageDefinitionValid) {
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("package.definition");
                    }
                });
                packageDefinition = SecurityManager.getPackages(string2);
                packageDefinitionValid = true;
            }
            for (int i = 0; i < packageDefinition.length; ++i) {
                if (!string.startsWith(packageDefinition[i]) && !packageDefinition[i].equals(string + ".")) continue;
                this.checkPermission(new RuntimePermission("defineClassInPackage." + string));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void checkPropertyAccess(String string) {
        this.checkPermission(new PropertyPermission(string, "read"));
    }

    public void checkRead(String string) {
        this.checkPermission(new FilePermission(string, "read"));
    }

    public void checkSecurityAccess(String string) {
        this.checkPermission(new SecurityPermission(string));
    }

    public void checkWrite(String string) {
        this.checkPermission(new FilePermission(string, "write"));
    }

    protected boolean inClass(String string) {
        return this.classDepth(string) >= 0;
    }

    public void checkAccept(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string + ":" + n, "accept"));
    }

    public void checkConnect(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(string + ":" + n, "connect"));
        }
    }

    public void checkAccess(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread can't be null");
        }
        if (thread.getThreadGroup() == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    private static ThreadGroup getRootGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (threadGroup == rootGroup) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string, "connect,accept"));
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        String string = inetAddress.getHostAddress();
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        this.checkPermission(new SocketPermission(string, "connect,accept"));
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkConnect(String string, int n, Object object) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (!string.startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"), object);
        } else {
            this.checkPermission(new SocketPermission(string + ":" + n, "connect"), object);
        }
    }

    public void checkRead(String string, Object object) {
        this.checkPermission(new FilePermission(string, "read"), object);
    }

    public void checkPermission(Permission permission, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        ((AccessControlContext)object).checkPermission(permission);
    }

    private static String[] getPackages(String string) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        if (string != null && !string.equals("") && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                stringArray[n2++] = string2;
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }
}

