/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.misc.MessageUtils;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static byte[] trim(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        String string = Converters.getDefaultEncodingName();
        try {
            return StringCoding.decode(string, byArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Converters.resetDefaultEncodingName();
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.decode("ISO-8859-1", byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    private static char[] trim(char[] cArray, int n) {
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        String string = Converters.getDefaultEncodingName();
        try {
            return StringCoding.encode(string, cArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Converters.resetDefaultEncodingName();
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.encode("ISO-8859-1", cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + unsupportedEncodingException2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            MessageUtils.err("WARNING: Default charset " + string + " not supported, using ISO-8859-1 instead");
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                stringDecoder = charset != null ? new CharsetSD(charset, string2) : null;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringDecoder == null) {
                stringDecoder = new ConverterSD(ByteToCharConverter.getConverter(string2), string2);
            }
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    stringEncoder = new CharsetSE(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringEncoder == null) {
                stringEncoder = new ConverterSE(CharToByteConverter.getConverter(string2), string2);
            }
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(cArray, n, n2);
    }

    private static Object deref(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static void set(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference(object));
    }

    private static Charset lookupCharset(String string) {
        if (string.equalsIgnoreCase("PCK")) {
            return null;
        }
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    private static class CharsetSD
    extends StringDecoder {
        private final Charset cs;
        private final CharsetDecoder cd;

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = (int)(this.cd.maxCharsPerByte() * (float)n2);
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.trim(cArray, charBuffer.position());
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        private CharsetSD(Charset charset, String string) {
            super(string);
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    private static class CharsetSE
    extends StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = (int)(this.ce.maxBytesPerChar() * (float)n2);
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.trim(byArray, byteBuffer.position());
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        private CharsetSE(Charset charset, String string) {
            super(string);
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    private static class ConverterSD
    extends StringDecoder {
        private ByteToCharConverter btc;

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = this.btc.getMaxCharsPerByte() * n2;
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.btc.reset();
            int n4 = 0;
            try {
                n4 = this.btc.convert(byArray, n, n + n2, cArray, 0, n3);
                n4 += this.btc.flush(cArray, this.btc.nextCharIndex(), n3);
            }
            catch (CharConversionException charConversionException) {
                n4 = this.btc.nextCharIndex();
            }
            return StringCoding.trim(cArray, n4);
        }

        String charsetName() {
            return this.btc.getCharacterEncoding();
        }

        private ConverterSD(ByteToCharConverter byteToCharConverter, String string) {
            super(string);
            this.btc = byteToCharConverter;
        }
    }

    private static class ConverterSE
    extends StringEncoder {
        private CharToByteConverter ctb;

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = this.ctb.getMaxBytesPerChar() * n2;
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ctb.reset();
            try {
                int n4 = this.ctb.convertAny(cArray, n, n + n2, byArray, 0, n3);
            }
            catch (CharConversionException charConversionException) {
                throw new Error("Converter malfunction: " + this.ctb.getClass().getName(), charConversionException);
            }
            return StringCoding.trim(byArray, n4 += this.ctb.flushAny(byArray, this.ctb.nextByteIndex(), n3));
        }

        String charsetName() {
            return this.ctb.getCharacterEncoding();
        }

        private ConverterSE(CharToByteConverter charToByteConverter, String string) {
            super(string);
            this.ctb = charToByteConverter;
        }
    }

    private static abstract class StringDecoder {
        private final String requestedCharsetName;

        abstract char[] decode(byte[] var1, int var2, int var3);

        abstract String charsetName();

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        protected StringDecoder(String string) {
            this.requestedCharsetName = string;
        }
    }

    private static abstract class StringEncoder {
        private final String requestedCharsetName;

        abstract byte[] encode(char[] var1, int var2, int var3);

        abstract String charsetName();

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        protected StringEncoder(String string) {
            this.requestedCharsetName = string;
        }
    }
}

