/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessControlContext;
import java.security.AccessController;
import sun.nio.ch.Interruptible;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private volatile Interruptible blocker;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public native int countStackFrames();

    public final int getPriority() {
        return this.priority;
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    static {
        Thread.registerNatives();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
    }

    public void interrupt() {
        this.checkAccess();
        Interruptible interruptible = this.blocker;
        if (interruptible != null) {
            interruptible.interrupt();
        }
        this.interrupt0();
    }

    private native void interrupt0();

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    private static native void registerNatives();

    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    private native void resume0();

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public synchronized native void start();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Thread thread = this;
        synchronized (thread) {
            if (!this.isAlive()) {
                return;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.checkAccess();
                if (this != Thread.currentThread()) {
                    securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
                }
            }
            this.resume();
            this.stop0(new ThreadDeath());
        }
    }

    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    private native void suspend0();

    public static native void yield();

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public final native boolean isAlive();

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    private native void setPriority0(int var1);

    public final synchronized void join(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l4;
            while (this.isAlive() && (l4 = l - l3) > 0L) {
                this.wait(l4);
                l3 = System.currentTimeMillis() - l2;
            }
        }
    }

    public static native void sleep(long var0) throws InterruptedException;

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep(l);
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl;
    }

    private native boolean isInterrupted(boolean var1);

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    private native void stop0(Object var1);

    public static native boolean holdsLock(Object var0);

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public static native Thread currentThread();

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public final synchronized void stop(Throwable throwable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        this.resume();
        this.stop0(throwable);
    }

    private void blockedOn(Interruptible interruptible) {
        this.blocker = interruptible;
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        Thread thread = Thread.currentThread();
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.contextClassLoader = thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l;
        threadGroup.add(this);
    }
}

