/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;

    private native int getStackTraceDepth();

    public Throwable() {
        this.fillInStackTrace();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printStream.println("\tat " + stackTraceElementArray[i]);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printStream, stackTraceElementArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTraceAsCause(printWriter, stackTraceElementArray);
            }
        }
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            int n = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[n];
            for (int i = 0; i < n; ++i) {
                this.stackTrace[i] = this.getStackTraceElement(i);
            }
        }
        return this.stackTrace;
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private native StackTraceElement getStackTraceElement(int var1);

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        this.stackTrace = stackTraceElementArray2;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    public Throwable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public synchronized native Throwable fillInStackTrace();

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public Throwable(Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    private void printStackTraceAsCause(PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + this);
        for (int i = 0; i <= n; ++i) {
            printStream.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printStream.println("\t... " + n2 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printStream, stackTraceElementArray2);
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printWriter.println("Caused by: " + this);
        for (int i = 0; i <= n; ++i) {
            printWriter.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printWriter.println("\t... " + n2 + " more");
        }
        if ((throwable = this.getCause()) != null) {
            throwable.printStackTraceAsCause(printWriter, stackTraceElementArray2);
        }
    }

    public Throwable(String string, Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = throwable;
        return this;
    }
}

