/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetPropertyAction;

public class DatagramSocket {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    DatagramSocketImpl impl;
    boolean oldImpl = false;
    static final int ST_NOT_CONNECTED = 0;
    static final int ST_CONNECTED = 1;
    static final int ST_CONNECTED_NO_IMPL = 2;
    int connectState = 0;
    InetAddress connectedAddress = null;
    int connectedPort = -1;
    static Class implClass = null;
    static DatagramSocketImplFactory factory;
    static /* synthetic */ Class class$java$net$DatagramPacket;

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getPort() {
        return this.connectedPort;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.getImpl() == null) {
            return 0;
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Integer)this.getImpl().getOption(3);
    }

    public DatagramSocket() throws SocketException {
        this.createImpl();
        try {
            this.bind(new InetSocketAddress(0));
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Class[] classArray = new Class[]{class$java$net$DatagramPacket == null ? (class$java$net$DatagramPacket = DatagramSocket.class$("java.net.DatagramPacket")) : class$java$net$DatagramPacket};
                    DatagramSocket.this.impl.getClass().getDeclaredMethod("peekData", classArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.oldImpl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.impl.close();
            this.closed = true;
        }
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            if (factory != null) {
                this.impl = factory.createDatagramSocketImpl();
                this.checkOldImpl();
            } else {
                if (implClass == null) {
                    String string = null;
                    try {
                        string = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", "Plain"));
                        implClass = Class.forName("java.net." + string + "DatagramSocketImpl");
                    }
                    catch (Exception exception) {
                        System.err.println("Can't find class: java.net." + string + "DatagramSocketImpl: check impl.prefix property");
                    }
                    if (implClass == null) {
                        implClass = PlainDatagramSocketImpl.class;
                    }
                }
                try {
                    this.impl = (DatagramSocketImpl)implClass.newInstance();
                }
                catch (Exception exception) {
                    throw new SocketException("can't instantiate DatagramSocketImpl");
                }
                if (!(this.impl instanceof PlainDatagramSocketImpl)) {
                    this.checkOldImpl();
                }
            }
        }
        this.impl.create();
        this.created = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        DatagramSocket datagramSocket = this;
        synchronized (datagramSocket) {
            if (this.isClosed()) {
                return;
            }
            if (this.connectState == 1) {
                this.impl.disconnect();
            }
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connectState = 0;
        }
    }

    public synchronized boolean getBroadcast() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(32);
    }

    public synchronized boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4);
        return (Boolean)object;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isConnected() {
        return this.connectState != 0;
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n));
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(n));
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(n));
    }

    public synchronized void setTrafficClass(int n) throws SocketException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(3, new Integer(n));
    }

    public synchronized void setBroadcast(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(32, new Boolean(bl));
    }

    public synchronized void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.oldImpl) {
            this.getImpl().setOption(4, new Integer(bl ? -1 : 0));
        } else {
            this.getImpl().setOption(4, new Boolean(bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            Object object;
            int n;
            Object object2;
            SecurityManager securityManager;
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            if (this.connectState == 0 && (securityManager = System.getSecurityManager()) != null) {
                while (true) {
                    object2 = null;
                    n = 0;
                    if (!this.oldImpl) {
                        object = new DatagramPacket(new byte[1], 1);
                        n = this.getImpl().peekData((DatagramPacket)object);
                        object2 = ((DatagramPacket)object).getAddress().getHostAddress();
                    } else {
                        object = new InetAddress();
                        n = this.getImpl().peek((InetAddress)object);
                        object2 = ((InetAddress)object).getHostAddress();
                    }
                    try {
                        securityManager.checkAccept((String)object2, n);
                    }
                    catch (SecurityException securityException) {
                        DatagramPacket datagramPacket3 = new DatagramPacket(new byte[1], 1);
                        this.getImpl().receive(datagramPacket3);
                        continue;
                    }
                    break;
                }
            }
            if (this.connectState == 2) {
                boolean bl = false;
                while (!bl) {
                    object2 = new InetAddress();
                    n = this.getImpl().peek((InetAddress)object2);
                    if (!this.connectedAddress.equals(object2) || this.connectedPort != n) {
                        object = new DatagramPacket(new byte[1], 1);
                        this.getImpl().receive((DatagramPacket)object);
                        continue;
                    }
                    bl = true;
                }
            }
            this.getImpl().receive(datagramPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket datagramPacket) throws IOException {
        InetAddress inetAddress = null;
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (this.connectState == 0) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (datagramPacket.getAddress().isMulticastAddress()) {
                        securityManager.checkMulticast(datagramPacket.getAddress());
                    } else {
                        securityManager.checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                    }
                }
            } else {
                inetAddress = datagramPacket.getAddress();
                if (inetAddress == null) {
                    datagramPacket.setAddress(this.connectedAddress);
                    datagramPacket.setPort(this.connectedPort);
                } else if (!inetAddress.equals(this.connectedAddress) || datagramPacket.getPort() != this.connectedPort) {
                    throw new IllegalArgumentException("connected address and packet address differ");
                }
            }
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            this.getImpl().send(datagramPacket);
        }
    }

    DatagramSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    protected DatagramSocket(DatagramSocketImpl datagramSocketImpl) {
        if (datagramSocketImpl == null) {
            throw new NullPointerException();
        }
        this.impl = datagramSocketImpl;
        this.checkOldImpl();
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory datagramSocketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = datagramSocketImplFactory;
    }

    public InetAddress getInetAddress() {
        return this.connectedAddress;
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        InetAddress inetAddress = null;
        try {
            SecurityManager securityManager;
            inetAddress = (InetAddress)this.getImpl().getOption(15);
            if (inetAddress.isAnyLocalAddress()) {
                inetAddress = InetAddress.anyLocalAddress();
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress();
        }
        return inetAddress;
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        this(new InetSocketAddress(inetAddress, n));
    }

    public void connect(InetAddress inetAddress, int n) {
        try {
            this.connectInternal(inetAddress, n);
        }
        catch (SocketException socketException) {
            throw new Error("connect failed", socketException);
        }
    }

    private synchronized void connectInternal(InetAddress inetAddress, int n) throws SocketException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("connect: " + n);
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (this.isClosed()) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkMulticast(inetAddress);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), n);
                securityManager.checkAccept(inetAddress.getHostAddress(), n);
            }
        }
        if (!this.isBound()) {
            this.bind(new InetSocketAddress(0));
        }
        if (this.oldImpl) {
            this.connectState = 2;
        } else {
            try {
                this.getImpl().connect(inetAddress, n);
                this.connectState = 1;
            }
            catch (SocketException socketException) {
                this.connectState = 2;
            }
        }
        this.connectedAddress = inetAddress;
        this.connectedPort = n;
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public DatagramSocket(SocketAddress socketAddress) throws SocketException {
        this.createImpl();
        if (socketAddress != null) {
            this.bind(socketAddress);
        }
    }

    public synchronized void bind(SocketAddress socketAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type!");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(inetSocketAddress.getPort());
        }
        try {
            this.getImpl().bind(inetSocketAddress.getPort(), inetSocketAddress.getAddress());
        }
        catch (SocketException socketException) {
            this.getImpl().close();
            throw socketException;
        }
        this.bound = true;
    }

    public void connect(SocketAddress socketAddress) throws SocketException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.connectInternal(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public DatagramChannel getChannel() {
        return null;
    }
}

