/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import sun.security.action.LoadLibraryAction;

public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;

    int getIndex() {
        return this.index;
    }

    public int hashCode() {
        int n = 0;
        if (this.addrs != null) {
            for (int i = 0; i < this.addrs.length; ++i) {
                n += this.addrs[i].hashCode();
            }
        }
        return n;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        NetworkInterface.init();
    }

    NetworkInterface() {
    }

    private static native void init();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Enumeration enumeration;
        int n;
        if (object == null || !(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        if (this.name != null) {
            if (networkInterface.getName() == null) return false;
            if (!this.name.equals(networkInterface.getName())) {
                return false;
            }
        } else if (networkInterface.getName() != null) {
            return false;
        }
        Enumeration enumeration2 = networkInterface.getInetAddresses();
        int n2 = 0;
        n2 = 0;
        while (enumeration2.hasMoreElements()) {
            enumeration2.nextElement();
            ++n2;
        }
        if (this.addrs == null) {
            if (n2 != 0) {
                return false;
            }
        } else {
            n = 0;
            enumeration = this.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            if (n2 != n) {
                return false;
            }
        }
        enumeration2 = networkInterface.getInetAddresses();
        while (enumeration2.hasMoreElements()) {
            n = 0;
            enumeration = this.getInetAddresses();
            InetAddress inetAddress = (InetAddress)enumeration2.nextElement();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress2 = (InetAddress)enumeration.nextElement();
                if (!inetAddress2.equals(inetAddress)) continue;
                n = 1;
            }
            if (n != 0) continue;
            return false;
        }
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String string = "name:";
        string = string + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            string = string + " (" + this.displayName + ")";
        }
        string = string + " index: " + this.index + " addresses:\n";
        Enumeration enumeration = this.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            string = string + inetAddress + ";\n";
        }
        return string;
    }

    private static native NetworkInterface[] getAll() throws SocketException;

    static native NetworkInterface getByIndex(int var0) throws SocketException;

    public Enumeration getInetAddresses() {
        class CheckedAddresses
        implements Enumeration {
            private int i = 0;
            private int count = 0;
            private Object[] local_addrs;

            public boolean hasMoreElements() {
                return this.i < this.count;
            }

            public Object nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            CheckedAddresses() {
                this.local_addrs = new Object[NetworkInterface.this.addrs.length];
                SecurityManager securityManager = System.getSecurityManager();
                for (int i = 0; i < NetworkInterface.this.addrs.length; ++i) {
                    try {
                        if (securityManager != null) {
                            securityManager.checkConnect(NetworkInterface.this.addrs[i].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.this.addrs[i];
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
        }
        return new CheckedAddresses();
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        final NetworkInterface[] networkInterfaceArray = NetworkInterface.getAll();
        if (networkInterfaceArray == null) {
            return null;
        }
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                return networkInterfaceArray != null && this.i < networkInterfaceArray.length;
            }

            public Object nextElement() {
                if (networkInterfaceArray != null && this.i < networkInterfaceArray.length) {
                    NetworkInterface networkInterface = networkInterfaceArray[this.i++];
                    return networkInterface;
                }
                throw new NoSuchElementException();
            }
        };
    }

    NetworkInterface(String string, int n, InetAddress[] inetAddressArray) {
        this.name = string;
        this.index = n;
        this.addrs = inetAddressArray;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByName0(string);
    }

    private static native NetworkInterface getByName0(String var0) throws SocketException;

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        return NetworkInterface.getByInetAddress0(inetAddress);
    }

    private static native NetworkInterface getByInetAddress0(InetAddress var0) throws SocketException;
}

