/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectIntBufferRU;
import java.nio.IntBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferU
extends IntBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int get() {
        return unsafe.getInt(this.ix(this.nextGetIndex()));
    }

    public long address() {
        return this.address;
    }

    static {
        $assertionsDisabled = !DirectIntBufferU.class.desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int get(int n) {
        return unsafe.getInt(this.ix(this.checkIndex(n)));
    }

    private long ix(int n) {
        return this.address + (long)(n << 2);
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public IntBuffer duplicate() {
        return new DirectIntBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 2;
        return new DirectIntBufferU(this, -1, 0, n3, n3, n4);
    }

    public IntBuffer put(int n) {
        unsafe.putInt(this.ix(this.nextPutIndex()), n);
        return this;
    }

    public IntBuffer put(int n, int n2) {
        unsafe.putInt(this.ix(this.checkIndex(n)), n2);
        return this;
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectIntBufferU.checkBounds(n, n2, nArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n4), nArray, n << 2, n2 << 2);
            } else {
                Bits.copyToByteArray(this.ix(n4), nArray, n << 2, n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.get(nArray, n, n2);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        if (n2 << 2 > 6) {
            int n3;
            DirectIntBufferU.checkBounds(n, n2, nArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(nArray, n << 2, this.ix(n4), n2 << 2);
            } else {
                Bits.copyFromByteArray(nArray, n << 2, this.ix(n4), n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.put(nArray, n, n2);
        }
        return this;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectIntBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.viewedBuffer = directBuffer;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferU) {
            int n;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferU directIntBufferU = (DirectIntBufferU)intBuffer;
            int n2 = directIntBufferU.position();
            int n3 = directIntBufferU.limit();
            if (!$assertionsDisabled && n2 > n3) {
                throw new AssertionError();
            }
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directIntBufferU.ix(n2), this.ix(n5), n4 << 2);
            directIntBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!intBuffer.isDirect()) {
            int n = intBuffer.position();
            int n8 = intBuffer.limit();
            if (!$assertionsDisabled && n > n8) {
                throw new AssertionError();
            }
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(intBuffer.hb, intBuffer.offset + n, n9);
            intBuffer.position(n + n9);
        } else {
            super.put(intBuffer);
        }
        return this;
    }
}

