/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapFloatBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class FloatBuffer
extends Buffer
implements Comparable {
    final float[] hb;
    final int offset;
    boolean isReadOnly;

    public abstract float get();

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final float[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public abstract float get(int var1);

    FloatBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    FloatBuffer(int n, int n2, int n3, int n4, float[] fArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = fArray;
        this.offset = n5;
    }

    public int compareTo(Object object) {
        FloatBuffer floatBuffer = (FloatBuffer)object;
        int n = this.position() + Math.min(this.remaining(), floatBuffer.remaining());
        int n2 = this.position();
        int n3 = floatBuffer.position();
        while (n2 < n) {
            float f;
            float f2 = this.get(n2);
            if (f2 != (f = floatBuffer.get(n3)) && (f2 == f2 || f == f)) {
                if (f2 < f) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - floatBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (this.remaining() != floatBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = floatBuffer.limit() - 1;
        while (n2 >= n) {
            float f;
            float f2 = this.get(n2);
            if (f2 != (f = floatBuffer.get(n3)) && (f2 == f2 || f == f)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteOrder order();

    public abstract FloatBuffer asReadOnlyBuffer();

    public abstract FloatBuffer compact();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer put(float var1);

    public static FloatBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapFloatBuffer(n, n);
    }

    public abstract FloatBuffer put(int var1, float var2);

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public static FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public FloatBuffer get(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            fArray[i] = this.get();
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(fArray[i]);
        }
        return this;
    }

    public static FloatBuffer wrap(float[] fArray, int n, int n2) {
        try {
            return new HeapFloatBuffer(fArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = floatBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(floatBuffer.get());
        }
        return this;
    }
}

