/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;

public class CodeSource
implements Serializable {
    private URL location;
    private transient Certificate[] certs;
    private transient SocketPermission sp;

    public int hashCode() {
        if (this.location != null) {
            return this.location.hashCode();
        }
        return 0;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = null;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            hashtable = new Hashtable(3);
            this.certs = new Certificate[n];
        }
        for (int i = 0; i < n; ++i) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)hashtable.get(string);
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw new ClassNotFoundException("Certificate factory for " + string + " not found");
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("Certificate too big");
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.certs[i] = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            byteArrayInputStream.close();
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                Certificate certificate = this.certs[i];
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CodeSource)) {
            return false;
        }
        CodeSource codeSource = (CodeSource)object;
        if (this.location == null ? codeSource.location != null : !this.location.equals(codeSource.location)) {
            return false;
        }
        if (this.certs == null) {
            if (codeSource.certs != null) {
                return false;
            }
        } else {
            int n;
            boolean bl;
            int n2;
            if (codeSource.certs == null) {
                return false;
            }
            for (n2 = 0; n2 < this.certs.length; ++n2) {
                bl = false;
                for (n = 0; n < codeSource.certs.length; ++n) {
                    if (!this.certs[n2].equals(codeSource.certs[n])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            for (n2 = 0; n2 < codeSource.certs.length; ++n2) {
                bl = false;
                for (n = 0; n < this.certs.length; ++n) {
                    if (!codeSource.certs[n2].equals(this.certs[n])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.location);
        if (this.certs != null && this.certs.length > 0) {
            for (int i = 0; i < this.certs.length; ++i) {
                stringBuffer.append(" " + this.certs[i]);
            }
        } else {
            stringBuffer.append(" <no certificates>");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final URL getLocation() {
        return this.location;
    }

    public boolean implies(CodeSource codeSource) {
        if (codeSource == null) {
            return false;
        }
        return this.matchCerts(codeSource) && this.matchLocation(codeSource);
    }

    private boolean matchCerts(CodeSource codeSource) {
        if (this.certs == null) {
            return true;
        }
        if (codeSource.certs == null) {
            return false;
        }
        for (int i = 0; i < this.certs.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < codeSource.certs.length; ++j) {
                if (!this.certs[i].equals(codeSource.certs[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean matchLocation(CodeSource codeSource) {
        int n;
        if (this.location == null) {
            return true;
        }
        if (codeSource == null || codeSource.location == null) {
            return false;
        }
        if (this.location.equals(codeSource.location)) {
            return true;
        }
        if (!this.location.getProtocol().equals(codeSource.location.getProtocol())) {
            return false;
        }
        if (!(this.location.getHost() == null || (this.location.getHost().equals("") || this.location.getHost().equals("localhost")) && (codeSource.location.getHost().equals("") || codeSource.location.getHost().equals("localhost")) || this.location.getHost().equals(codeSource.location.getHost()))) {
            if (this.sp == null) {
                this.sp = new SocketPermission(this.location.getHost(), "resolve");
            }
            if (codeSource.sp == null) {
                if (codeSource.location.getHost() == null || codeSource.location.getHost().equals("")) {
                    return false;
                }
                codeSource.sp = new SocketPermission(codeSource.location.getHost(), "resolve");
            }
            if ((n = (int)(this.sp.implies(codeSource.sp) ? 1 : 0)) == 0) {
                return false;
            }
        }
        if (this.location.getPort() != -1 && this.location.getPort() != codeSource.location.getPort()) {
            return false;
        }
        if (this.location.getFile().endsWith("/-")) {
            String string = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            if (!codeSource.location.getFile().startsWith(string)) {
                return false;
            }
        } else if (this.location.getFile().endsWith("/*")) {
            n = codeSource.location.getFile().lastIndexOf(47);
            if (n == -1) {
                return false;
            }
            String string = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            String string2 = codeSource.location.getFile().substring(0, n + 1);
            if (!string2.equals(string)) {
                return false;
            }
        } else if (!codeSource.location.getFile().equals(this.location.getFile()) && !codeSource.location.getFile().equals(this.location.getFile() + "/")) {
            return false;
        }
        if (this.location.getRef() == null) {
            return true;
        }
        return this.location.getRef().equals(codeSource.location.getRef());
    }

    public final Certificate[] getCertificates() {
        if (this.certs != null) {
            return (Certificate[])this.certs.clone();
        }
        return null;
    }

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.location = uRL;
        if (certificateArray != null) {
            this.certs = (Certificate[])certificateArray.clone();
        }
    }
}

