/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private boolean initialized = false;
    private HashMap pdcache = new HashMap(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        return new Permissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = null;
        HashMap hashMap = this.pdcache;
        synchronized (hashMap) {
            PermissionCollection permissionCollection;
            protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
            if (protectionDomain == null && (protectionDomain = new ProtectionDomain(codeSource, permissionCollection = this.getPermissions(codeSource), this, null)) != null) {
                this.pdcache.put(codeSource, protectionDomain);
                if (debug != null) {
                    debug.println(" getPermissions " + protectionDomain);
                    debug.println("");
                }
            }
        }
        return protectionDomain;
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        if (codeSource == null) {
            return this.defineClass(string, byArray, n, n2);
        }
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }
}

