/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.security.util.Debug;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private static final Debug debug = Debug.getInstance("policy,access", "UnresolvedPermission");
    private String type;
    private String name;
    private String actions;
    private transient Certificate[] certs;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    public int hashCode() {
        int n = this.type.hashCode();
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n ^= this.actions.hashCode();
        }
        return n;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = null;
        objectInputStream.defaultReadObject();
        if (this.type == null) {
            throw new NullPointerException("type can't be null");
        }
        int n = objectInputStream.readInt();
        if (n > 0) {
            hashtable = new Hashtable(3);
            this.certs = new Certificate[n];
        }
        for (int i = 0; i < n; ++i) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)hashtable.get(string);
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw new ClassNotFoundException("Certificate factory for " + string + " not found");
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("Certificate too big");
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.certs[i] = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            byteArrayInputStream.close();
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                Certificate certificate = this.certs[i];
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
            }
        }
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        int n2;
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission unresolvedPermission = (UnresolvedPermission)object;
        if (!this.type.equals(unresolvedPermission.type)) {
            return false;
        }
        if (this.name == null ? unresolvedPermission.name != null : !this.name.equals(unresolvedPermission.name)) {
            return false;
        }
        if (this.actions == null ? unresolvedPermission.actions != null : !this.actions.equals(unresolvedPermission.actions)) {
            return false;
        }
        if (this.certs == null && unresolvedPermission.certs != null || this.certs != null && unresolvedPermission.certs == null || this.certs != null && unresolvedPermission.certs != null && this.certs.length != unresolvedPermission.certs.length) {
            return false;
        }
        for (n2 = 0; this.certs != null && n2 < this.certs.length; ++n2) {
            bl = false;
            for (n = 0; n < unresolvedPermission.certs.length; ++n) {
                if (!this.certs[n2].equals(unresolvedPermission.certs[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; unresolvedPermission.certs != null && n2 < unresolvedPermission.certs.length; ++n2) {
            bl = false;
            for (n = 0; n < this.certs.length; ++n) {
                if (!unresolvedPermission.certs[n2].equals(this.certs[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String getActions() {
        return "";
    }

    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    Permission resolve(Permission permission, Certificate[] certificateArray) {
        if (this.certs != null) {
            if (certificateArray == null) {
                return null;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < certificateArray.length; ++j) {
                    if (!this.certs[i].equals(certificateArray[j])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return null;
            }
        }
        try {
            Class clazz = permission.getClass();
            if (this.name == null && this.actions == null) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS0);
                    return (Permission)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Constructor constructor = clazz.getConstructor(PARAMS1);
                        return (Permission)constructor.newInstance(new Object[]{this.name});
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        Constructor constructor = clazz.getConstructor(PARAMS2);
                        return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
                    }
                }
            }
            if (this.name != null && this.actions == null) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS1);
                    return (Permission)constructor.newInstance(new Object[]{this.name});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Constructor constructor = clazz.getConstructor(PARAMS2);
                    return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
                }
            }
            Constructor constructor = clazz.getConstructor(PARAMS2);
            return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.println("NoSuchMethodException:\n  could not find proper constructor for " + this.type);
                noSuchMethodException.printStackTrace();
            }
            return null;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("unable to instantiate " + this.name);
                exception.printStackTrace();
            }
            return null;
        }
    }

    public UnresolvedPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException("type can't be null");
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n;
            for (n = 0; n < certificateArray.length; ++n) {
                if (certificateArray[n] instanceof X509Certificate) continue;
                this.certs = (Certificate[])certificateArray.clone();
                break;
            }
            if (this.certs == null) {
                int n2 = 0;
                for (n = 0; n < certificateArray.length; ++n) {
                    ++n2;
                    while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                        ++n;
                    }
                }
                if (n2 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList arrayList = new ArrayList();
                    for (n = 0; n < certificateArray.length; ++n) {
                        arrayList.add(certificateArray[n]);
                        while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                            ++n;
                        }
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }
}

