/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    private String type;

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + ((Object)this.getCertificates()).hashCode();
        return n;
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            notSerializableException.initCause(certificateException);
            throw notSerializableException;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)object;
        if (!certPath.getType().equals(this.type)) {
            return false;
        }
        List list = this.getCertificates();
        List list2 = certPath.getCertificates();
        return ((Object)list).equals(list2);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getCertificates().iterator();
        stringBuffer.append("\n" + this.type + " Cert Path: length = " + this.getCertificates().size() + ".\n");
        stringBuffer.append("[\n");
        int n = 1;
        while (iterator.hasNext()) {
            stringBuffer.append("=========================================================Certificate " + n + " start.\n");
            Certificate certificate = (Certificate)iterator.next();
            stringBuffer.append(certificate.toString());
            stringBuffer.append("\n=========================================================Certificate " + n + " end.\n\n\n");
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    protected CertPath(String string) {
        this.type = string;
    }

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract Iterator getEncodings();

    public abstract List getCertificates();

    protected static class CertPathRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                notSerializableException.initCause(certificateException);
                throw notSerializableException;
            }
        }

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }
    }
}

