/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import sun.security.x509.X509CertImpl;

public abstract class Certificate
implements Serializable {
    private final String type;

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = X509CertImpl.getEncodedInternal(this);
            for (int i = 1; i < byArray.length; ++i) {
                n += byArray[i] * i;
            }
            return n;
        }
        catch (CertificateException certificateException) {
            return n;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        try {
            byte[] byArray = X509CertImpl.getEncodedInternal(this);
            byte[] byArray2 = X509CertImpl.getEncodedInternal((Certificate)object);
            return Arrays.equals(byArray, byArray2);
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public final String getType() {
        return this.type;
    }

    public abstract String toString();

    protected Certificate(String string) {
        this.type = string;
    }

    public abstract PublicKey getPublicKey();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected static class CertificateRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                throw new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage());
            }
        }

        protected CertificateRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }
    }
}

