/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXParameters;
import java.util.Set;

public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength = 5;

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int n) {
        if (n < -1) {
            throw new InvalidParameterException("the maximum path length parameter can not be less than -1");
        }
        this.maxPathLength = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("  Maximum Path Length: " + this.maxPathLength + "\n");
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    public PKIXBuilderParameters(KeyStore keyStore, CertSelector certSelector) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keyStore);
        this.setTargetCertConstraints(certSelector);
    }

    public PKIXBuilderParameters(Set set, CertSelector certSelector) throws InvalidAlgorithmParameterException {
        super(set);
        this.setTargetCertConstraints(certSelector);
    }
}

