/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.TextBoundaryData;

final class SimpleTextBoundary
extends BreakIterator {
    private transient int pos;
    private transient CharacterIterator text;
    private TextBoundaryData data;
    private static final char END_OF_STRING = '\uffff';

    public int current() {
        return this.pos;
    }

    public int first() {
        this.pos = this.text.getBeginIndex();
        return this.pos;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.text.hashCode();
    }

    public int last() {
        this.pos = this.text.getEndIndex();
        return this.pos;
    }

    public int next() {
        int n = this.pos;
        n = this.pos < this.text.getEndIndex() ? (this.pos = this.nextPosition(this.pos)) : -1;
        return n;
    }

    public int previous() {
        if (this.pos > this.text.getBeginIndex()) {
            int n = this.pos;
            int n2 = this.pos = this.previousSafePosition(this.pos - 1);
            int n3 = this.next();
            while (n3 < n && n3 != -1) {
                n2 = n3;
                n3 = this.next();
            }
            this.pos = n2;
            return this.pos;
        }
        return -1;
    }

    protected int mappedChar(char c) {
        return this.data.map().mappedChar(c);
    }

    public int following(int n) {
        int n2;
        if (n < this.text.getBeginIndex() || n >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("nextBoundaryAt offset out of bounds");
        }
        this.pos = this.previousSafePosition(n);
        while ((n2 = this.next()) <= n && n2 != -1) {
        }
        return n2;
    }

    public int next(int n) {
        int n2 = this.current();
        if (n < 0) {
            for (int i = n; i < 0 && n2 != -1; ++i) {
                n2 = this.previous();
            }
        } else {
            for (int i = n; i > 0 && n2 != -1; --i) {
                n2 = this.next();
            }
        }
        return n2;
    }

    private int nextPosition(int n) {
        int n2 = this.text.getEndIndex();
        int n3 = this.data.forward().initialState();
        char c = this.text.setIndex(n);
        while (c != '\uffff' && !this.data.forward().isEndState(n3)) {
            n3 = this.data.forward().get(n3, this.mappedChar(c));
            if (this.data.forward().isMarkState(n3)) {
                n2 = this.text.getIndex();
            }
            c = this.text.next();
        }
        if (this.data.forward().isEndState(n3)) {
            return n2;
        }
        n3 = this.data.forward().get(n3, this.mappedChar('\uffff'));
        if (this.data.forward().isMarkState(n3)) {
            return this.text.getEndIndex();
        }
        return n2;
    }

    public int preceding(int n) {
        int n2;
        if (n < this.text.getBeginIndex() || n >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("preceding() offset out of bounds");
        }
        if (n == this.text.getBeginIndex()) {
            return -1;
        }
        int n3 = this.pos = this.previousSafePosition(n);
        do {
            n2 = n3;
        } while ((n3 = this.next()) < n && n3 != -1);
        this.pos = n2;
        return n2;
    }

    private int previousSafePosition(int n) {
        int n2 = this.text.getBeginIndex();
        int n3 = this.data.backward().initialState();
        if (n == n2) {
            ++n;
        }
        char c = this.text.setIndex(n - 1);
        while (c != '\uffff' && !this.data.backward().isEndState(n3)) {
            n3 = this.data.backward().get(n3, this.mappedChar(c));
            if (this.data.backward().isMarkState(n3)) {
                n2 = this.text.getIndex();
            }
            c = this.text.previous();
        }
        return n2;
    }

    public boolean isBoundary(int n) {
        int n2 = this.text.getBeginIndex();
        if (n < n2 || n >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("isBoundary offset out of bounds");
        }
        if (n == n2) {
            return true;
        }
        return this.following(n - 1) == n;
    }

    public Object clone() {
        try {
            SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)super.clone();
            simpleTextBoundary.text = (CharacterIterator)this.text.clone();
            return simpleTextBoundary;
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTextBoundary)) {
            return false;
        }
        SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)object;
        if (this.data.getClass() != simpleTextBoundary.data.getClass()) {
            return false;
        }
        if (this.hashCode() != simpleTextBoundary.hashCode()) {
            return false;
        }
        if (this.pos != simpleTextBoundary.pos) {
            return false;
        }
        return this.text.equals(simpleTextBoundary.text);
    }

    public void setText(String string) {
        this.text = new StringCharacterIterator(string);
        this.pos = this.text.getBeginIndex();
    }

    public CharacterIterator getText() {
        return this.text;
    }

    public void setText(CharacterIterator characterIterator) {
        this.text = characterIterator;
        this.pos = this.text.getBeginIndex();
    }

    protected SimpleTextBoundary(TextBoundaryData textBoundaryData) {
        this.data = textBoundaryData;
        this.text = new StringCharacterIterator("");
        this.pos = this.text.getBeginIndex();
    }
}

