/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import sun.misc.AtomicLong;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private AtomicLong seed = AtomicLong.newAtomicLong(0L);
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};

    public double nextDouble() {
        long l = ((long)this.next(26) << 27) + (long)this.next(27);
        return (double)l / 9.007199254740992E15;
    }

    public synchronized double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public float nextFloat() {
        int n = this.next(24);
        return (float)n / 1.6777216E7f;
    }

    public int nextInt() {
        return this.next(32);
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public Random() {
        this(System.currentTimeMillis());
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    protected int next(int n) {
        long l;
        long l2;
        while (!this.seed.attemptUpdate(l2 = this.seed.get(), l = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(l >>> 48 - n);
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public Random(long l) {
        this.setSeed(l);
    }

    public synchronized void setSeed(long l) {
        l = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        while (!this.seed.attemptSet(l)) {
        }
        this.haveNextNextGaussian = false;
    }

    public void nextBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        block0: while (true) {
            int n4 = 0;
            while (true) {
                if (n4 >= 4) continue block0;
                if (n2 == n) {
                    return;
                }
                n3 = n4 == 0 ? this.next(32) : n3 >> 8;
                byArray[n2++] = (byte)n3;
                ++n4;
            }
            break;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        long l = getField.get("seed", -1L);
        if (l < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.seed = AtomicLong.newAtomicLong(l);
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("seed", this.seed.get());
        putField.put("nextNextGaussian", this.nextNextGaussian);
        putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
        objectOutputStream.writeFields();
    }
}

