/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import sun.security.action.GetIntegerAction;

public final class InetAddressCachePolicy {
    private static final String cachePolicyProp = "networkaddress.cache.ttl";
    private static final String cachePolicyPropFallback = "sun.net.inetaddr.ttl";
    private static final String negativeCachePolicyProp = "networkaddress.cache.negative.ttl";
    private static final String negativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
    public static final int FOREVER = -1;
    public static final int NEVER = 0;
    private static int cachePolicy;
    private static int negativeCachePolicy;
    private static boolean set;
    private static boolean negativeSet;

    public static synchronized int get() {
        return cachePolicy;
    }

    public static synchronized int getNegative() {
        return negativeCachePolicy;
    }

    static {
        set = false;
        negativeSet = false;
        set = false;
        negativeSet = false;
        cachePolicy = -1;
        negativeCachePolicy = 0;
        Integer n = null;
        try {
            n = new Integer((String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty(InetAddressCachePolicy.cachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n != null) {
            cachePolicy = n;
            if (cachePolicy < 0) {
                cachePolicy = -1;
            }
            set = true;
        } else {
            n = (Integer)AccessController.doPrivileged(new GetIntegerAction(cachePolicyPropFallback));
            if (n != null) {
                cachePolicy = n;
                if (cachePolicy < 0) {
                    cachePolicy = -1;
                }
                set = true;
            }
        }
        try {
            n = new Integer((String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty(InetAddressCachePolicy.negativeCachePolicyProp);
                }
            }));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n != null) {
            negativeCachePolicy = n;
            if (negativeCachePolicy < 0) {
                negativeCachePolicy = -1;
            }
            negativeSet = true;
        } else {
            n = (Integer)AccessController.doPrivileged(new GetIntegerAction(negativeCachePolicyPropFallback));
            if (n != null) {
                negativeCachePolicy = n;
                if (negativeCachePolicy < 0) {
                    negativeCachePolicy = -1;
                }
                negativeSet = true;
            }
        }
    }

    public static synchronized void setIfNotSet(int n) {
        if (!set) {
            InetAddressCachePolicy.checkValue(n, cachePolicy);
            cachePolicy = n;
        }
    }

    public static synchronized void setNegativeIfNotSet(int n) {
        if (!negativeSet) {
            negativeCachePolicy = n;
        }
    }

    private static void checkValue(int n, int n2) {
        if (n == -1) {
            return;
        }
        if (n2 == -1 || n < n2 || n < -1) {
            throw new SecurityException("can't make InetAddress cache more lax");
        }
    }
}

