/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class NetworkServer
implements Runnable,
Cloneable {
    public Socket clientSocket = null;
    private Thread serverInstance;
    private ServerSocket serverSocket;
    public PrintStream clientOutput;
    public InputStream clientInput;

    public void close() throws IOException {
        this.clientSocket.close();
        this.clientSocket = null;
        this.clientInput = null;
        this.clientOutput = null;
    }

    public final void run() {
        if (this.serverSocket != null) {
            Thread.currentThread().setPriority(10);
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    NetworkServer networkServer = (NetworkServer)this.clone();
                    networkServer.serverSocket = null;
                    networkServer.clientSocket = socket;
                    new Thread(networkServer).start();
                }
            }
            catch (Exception exception) {
                System.out.print("Server failure\n");
                exception.printStackTrace();
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.out.print("cs=" + this.serverSocket + "\n");
            }
        } else {
            try {
                this.clientOutput = new PrintStream(new BufferedOutputStream(this.clientSocket.getOutputStream()), false, "ISO8859_1");
                this.clientInput = new BufferedInputStream(this.clientSocket.getInputStream());
                this.serviceRequest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void serviceRequest() throws IOException {
        int n;
        byte[] byArray = new byte[300];
        this.clientOutput.print("Echo server " + this.getClass().getName() + "\n");
        this.clientOutput.flush();
        while ((n = this.clientInput.read(byArray, 0, byArray.length)) >= 0) {
            this.clientOutput.write(byArray, 0, n);
        }
    }

    public boolean clientIsOpen() {
        return this.clientSocket != null;
    }

    public final void startServer(int n) throws IOException {
        this.serverSocket = new ServerSocket(n, 50);
        this.serverInstance = new Thread(this);
        this.serverInstance.start();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        try {
            new NetworkServer().startServer(8888);
        }
        catch (IOException iOException) {
            System.out.print("Server failed: " + iOException + "\n");
        }
    }
}

