/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.AccessController;
import sun.net.TransferProtocolClient;
import sun.net.smtp.SmtpPrintStream;
import sun.net.smtp.SmtpProtocolException;
import sun.security.action.GetPropertyAction;

public class SmtpClient
extends TransferProtocolClient {
    String mailhost;
    SmtpPrintStream message;

    public SmtpClient() throws IOException {
        this(null);
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        try {
            this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + " encoding not found");
        }
        return this.message;
    }

    String getEncoding() {
        return encoding;
    }

    public String getMailHost() {
        return this.mailhost;
    }

    public SmtpClient(String string) throws IOException {
        if (string != null) {
            try {
                this.openServer(string);
                this.mailhost = string;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mailhost = (String)AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (this.mailhost != null) {
                this.openServer(this.mailhost);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mailhost = "localhost";
            this.openServer(this.mailhost);
        }
        catch (Exception exception) {
            this.mailhost = "mailhost";
            this.openServer(this.mailhost);
        }
    }

    public void from(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("mail from: " + string + "\r\n", 250);
        } else {
            this.issueCommand("mail from: <" + string + ">\r\n", 250);
        }
    }

    private void openServer(String string) throws IOException {
        this.mailhost = string;
        this.openServer(this.mailhost, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public void to(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (n4 > 0) {
                if (c == '(') {
                    ++n4;
                } else if (c == ')') {
                    --n4;
                }
                if (n4 != 0) continue;
                if (n3 > n) {
                    bl = true;
                    continue;
                }
                n = i + 1;
                continue;
            }
            if (c == '(') {
                ++n4;
                continue;
            }
            if (c == '<') {
                n = n3 = i + 1;
                continue;
            }
            if (c == '>') {
                bl = true;
                continue;
            }
            if (c == ',') {
                if (n3 > n) {
                    this.toCanonical(string.substring(n, n3));
                }
                n = i + 1;
                bl = false;
                continue;
            }
            if (c > ' ' && !bl) {
                n3 = i + 1;
                continue;
            }
            if (n != i) continue;
            ++n;
        }
        if (n3 > n) {
            this.toCanonical(string.substring(n, n3));
        }
    }

    private void toCanonical(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("rcpt to: " + string + "\r\n", 250);
        } else {
            this.issueCommand("rcpt to: <" + string + ">\r\n", 250);
        }
    }

    void issueCommand(String string, int n) throws IOException {
        int n2;
        this.sendServer(string);
        while ((n2 = this.readServerResponse()) != n) {
            if (n2 == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }
}

