/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.ftp;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.util.StringTokenizer;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.ftp.FtpClient;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetPropertyAction;

public class FtpURLConnection
extends URLConnection {
    InputStream is = null;
    OutputStream os = null;
    FtpClient ftp = null;
    Permission permission;
    String password;
    String user;
    String host;
    String pathname;
    String filename;
    String fullpath;
    int port;
    static final int NONE = 0;
    static final int ASCII = 1;
    static final int BIN = 2;
    static final int DIR = 3;
    int type = 0;

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.user == null) {
            this.user = "anonymous";
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
            this.password = (String)AccessController.doPrivileged(new GetPropertyAction("ftp.protocol.user", "Java" + string + "@"));
        }
        this.ftp = this.port != -1 ? new FtpClient(this.host, this.port) : new FtpClient(this.host);
        this.ftp.login(this.user, this.password);
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.os != null) {
            throw new IOException("Already opened for output");
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader messageHeader = new MessageHeader();
        try {
            String string;
            this.decodePath(this.url.getPath());
            if (this.filename == null || this.type == 3) {
                this.ftp.ascii();
                this.cd(this.pathname);
                this.is = this.filename == null ? new FtpInputStream(this.ftp, this.ftp.list()) : new FtpInputStream(this.ftp, this.ftp.nameList(this.filename));
            } else {
                if (this.type == 1) {
                    this.ftp.ascii();
                } else {
                    this.ftp.binary();
                }
                this.cd(this.pathname);
                this.is = new FtpInputStream(this.ftp, this.ftp.get(this.filename));
            }
            try {
                string = this.ftp.getResponseString();
                int n = string.indexOf(" bytes)");
                if (n != -1) {
                    char c;
                    int n2 = n;
                    while (--n2 >= 0 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    }
                    n2 = Integer.parseInt(string.substring(n2 + 1, n));
                    messageHeader.add("content-length", "" + n2);
                    if (n2 > 0) {
                        ProgressEntry progressEntry = new ProgressEntry(this.fullpath, null);
                        progressEntry.update(0, n2);
                        ProgressData.pdata.register(progressEntry);
                        this.is = new MeteredStream(this.is, progressEntry);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = FtpURLConnection.guessContentTypeFromName(this.fullpath);
            if (string == null && this.is.markSupported()) {
                string = FtpURLConnection.guessContentTypeFromStream(this.is);
            }
            if (string != null) {
                messageHeader.add("content-type", string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.cd(this.fullpath);
                this.ftp.ascii();
                this.is = this.ftp.list();
                messageHeader.add("content-type", "text/plain");
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(this.fullpath);
            }
        }
        this.setProperties(messageHeader);
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.is != null) {
            throw new IOException("Already opened for input");
        }
        if (this.os != null) {
            return this.os;
        }
        this.decodePath(this.url.getPath());
        if (this.filename == null || this.filename.length() == 0) {
            throw new IOException("illegal filename for a PUT");
        }
        if (this.pathname != null) {
            this.cd(this.pathname);
        }
        if (this.type == 1) {
            this.ftp.ascii();
        } else {
            this.ftp.binary();
        }
        this.os = new FtpOutputStream(this.ftp, this.ftp.put(this.filename));
        return this.os;
    }

    private void cd(String string) throws IOException {
        if (string == null || "".equals(string)) {
            return;
        }
        if (string.indexOf(47) == -1) {
            this.ftp.cd(ParseUtil.decode(string));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            this.ftp.cd(ParseUtil.decode(stringTokenizer.nextToken()));
        }
    }

    private void decodePath(String string) {
        int n = string.indexOf(";type=");
        if (n >= 0) {
            String string2 = string.substring(n + 6, string.length());
            if ("i".equalsIgnoreCase(string2)) {
                this.type = 2;
            }
            if ("a".equalsIgnoreCase(string2)) {
                this.type = 1;
            }
            if ("d".equalsIgnoreCase(string2)) {
                this.type = 3;
            }
            string = string.substring(0, n);
        }
        if (string != null && string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string == null || string.length() == 0) {
            string = "./";
        }
        if (!string.endsWith("/")) {
            n = string.lastIndexOf(47);
            if (n > 0) {
                this.filename = string.substring(n + 1, string.length());
                this.filename = ParseUtil.decode(this.filename);
                this.pathname = string.substring(0, n);
            } else {
                this.filename = ParseUtil.decode(string);
                this.pathname = null;
            }
        } else {
            this.pathname = string.substring(0, string.length() - 1);
            this.filename = null;
        }
        this.fullpath = this.pathname != null ? this.pathname + "/" + (this.filename != null ? this.filename : "") : this.filename;
    }

    public FtpURLConnection(URL uRL) {
        super(uRL);
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n == -1) {
                this.user = ParseUtil.decode(string);
                this.password = null;
            } else {
                this.user = ParseUtil.decode(string.substring(0, n++));
                this.password = ParseUtil.decode(string.substring(n));
            }
        }
    }

    public Permission getPermission() {
        if (this.permission == null) {
            int n = this.url.getPort();
            n = n < 0 ? 21 : n;
            String string = this.host + ":" + n;
            this.permission = new SocketPermission(string, "connect");
        }
        return this.permission;
    }

    public String getRequestProperty(String string) {
        String string2 = super.getRequestProperty(string);
        if (string2 == null && "type".equals(string)) {
            string2 = this.type == 1 ? "a" : (this.type == 3 ? "d" : "i");
        }
        return string2;
    }

    String guessContentTypeFromFilename(String string) {
        return FtpURLConnection.guessContentTypeFromName(string);
    }

    public void setRequestProperty(String string, String string2) {
        super.setRequestProperty(string, string2);
        if ("type".equals(string)) {
            if ("i".equalsIgnoreCase(string2)) {
                this.type = 2;
            } else if ("a".equalsIgnoreCase(string2)) {
                this.type = 1;
            } else if ("d".equalsIgnoreCase(string2)) {
                this.type = 3;
            } else {
                throw new IllegalArgumentException("Value of '" + string + "' request property was '" + string2 + "' when it must be either 'i', 'a' or 'd'");
            }
        }
    }

    protected class FtpInputStream
    extends FilterInputStream {
        FtpClient ftp;

        public void close() throws IOException {
            super.close();
            try {
                if (this.ftp != null) {
                    this.ftp.closeServer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        FtpInputStream(FtpClient ftpClient, InputStream inputStream) {
            super(new BufferedInputStream(inputStream));
            this.ftp = ftpClient;
        }
    }

    protected class FtpOutputStream
    extends FilterOutputStream {
        FtpClient ftp;

        public void close() throws IOException {
            super.close();
            try {
                if (this.ftp != null) {
                    this.ftp.closeServer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        FtpOutputStream(FtpClient ftpClient, OutputStream outputStream) {
            super(outputStream);
            this.ftp = ftpClient;
        }
    }
}

