/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.Util;

class IOVecWrapper {
    static int BASE_OFFSET = 0;
    static int LEN_OFFSET = addressSize = Util.unsafe().addressSize();
    static int SIZE_IOVEC = (short)(addressSize * 2);
    private AllocatedNativeObject vecArray;
    long address;
    static int addressSize;

    void free() {
        this.vecArray.free();
    }

    IOVecWrapper(int n) {
        n = (n + 1) * SIZE_IOVEC;
        this.vecArray = new AllocatedNativeObject(n, false);
        this.address = this.vecArray.address();
    }

    void putBase(int n, long l) {
        int n2 = SIZE_IOVEC * n + BASE_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(n2, (int)l);
        } else {
            this.vecArray.putLong(n2, l);
        }
    }

    void putLen(int n, long l) {
        int n2 = SIZE_IOVEC * n + LEN_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(n2, (int)l);
        } else {
            this.vecArray.putLong(n2, l);
        }
    }
}

