/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.SelectionKeyImpl;

class PollArrayWrapper {
    private AllocatedNativeObject pollArray;
    long pollArrayAddress;
    private static final short FD_OFFSET = 0;
    private static final short EVENT_OFFSET = 4;
    static short SIZE_POLLFD = (short)8;
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 2;
    private int size;

    void free() {
        this.pollArray.free();
    }

    int getDescriptor(int n) {
        return this.pollArray.getInt(SIZE_POLLFD * n + 0);
    }

    int getEventOps(int n) {
        return this.pollArray.getShort(SIZE_POLLFD * n + 4);
    }

    PollArrayWrapper(int n) {
        int n2 = n * SIZE_POLLFD;
        this.pollArray = new AllocatedNativeObject(n2, true);
        this.pollArrayAddress = this.pollArray.address();
        this.size = n;
    }

    void grow(int n) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n);
        for (int i = 0; i < this.size; ++i) {
            this.replaceEntry(this, i, pollArrayWrapper, i);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.size = pollArrayWrapper.size;
        this.pollArrayAddress = this.pollArray.address();
    }

    void addWakeupSocket(int n, int n2) {
        this.putDescriptor(n2, n);
        this.putEventOps(n2, 1);
    }

    void putDescriptor(int n, int n2) {
        this.pollArray.putInt(SIZE_POLLFD * n + 0, n2);
    }

    void putEventOps(int n, int n2) {
        this.pollArray.putShort(SIZE_POLLFD * n + 4, (short)n2);
    }

    void addEntry(int n, SelectionKeyImpl selectionKeyImpl) {
        this.putDescriptor(n, selectionKeyImpl.channel.getFDVal());
    }

    void replaceEntry(PollArrayWrapper pollArrayWrapper, int n, PollArrayWrapper pollArrayWrapper2, int n2) {
        pollArrayWrapper2.putDescriptor(n2, pollArrayWrapper.getDescriptor(n));
        pollArrayWrapper2.putEventOps(n2, pollArrayWrapper.getEventOps(n));
    }
}

