/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private InputStream socketInputStream = null;

    public int getLocalPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getPort();
    }

    public int getPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.opts().getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public int getTrafficClass() throws SocketException {
        int n = this.opts().getTrafficClass();
        if (n < 0) {
            n = this.trafficClass;
        }
        return n;
    }

    public void close() throws IOException {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        return this.opts().getKeepAlive();
    }

    public boolean getOOBInline() throws SocketException {
        return this.opts().getOOBInline();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.opts().getTcpNoDelay();
    }

    public boolean isBound() {
        return this.sc.isBound();
    }

    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    public void sendUrgentData(int n) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.opts().setReceiveBufferSize(n);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.opts().setSendBufferSize(n);
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    public void setTrafficClass(int n) throws SocketException {
        this.opts().setTrafficClass(n);
        this.trafficClass = n;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.opts().setKeepAlive(bl);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.opts().setOOBInline(bl);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.opts().setReuseAddress(bl);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.opts().setTcpNoDelay(bl);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.opts().setSoLinger(bl, n);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public InetAddress getInetAddress() {
        if (!this.sc.isConnected()) {
            return null;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.sc.isBound()) {
            return new InetSocketAddress(0).getAddress();
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getAddress();
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (n == 0) {
                    this.sc.connect(socketAddress);
                    return;
                }
                SelectionKey selectionKey = null;
                this.sc.configureBlocking(false);
                try {
                    block17: {
                        long l;
                        if (this.sc.connect(socketAddress)) {
                            Object var12_6 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (!this.sc.isOpen()) return;
                            this.sc.configureBlocking(true);
                            return;
                        }
                        Selector selector = Util.getTemporarySelector(this.sc);
                        selectionKey = this.sc.register(selector, 8);
                        long l2 = n;
                        do {
                            l = System.currentTimeMillis();
                            selector.select(l2);
                            if (selectionKey.isConnectable() && this.sc.finishConnect()) break block17;
                            selector.selectedKeys().remove(selectionKey);
                        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                        try {
                            this.sc.close();
                            throw new SocketTimeoutException();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    Object var12_7 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (!this.sc.isOpen()) return;
                    this.sc.configureBlocking(true);
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (!this.sc.isOpen()) throw throwable;
                    this.sc.configureBlocking(true);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Net.translateException(exception, true);
            }
            return;
        }
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.sc);
        }
        return this.opts;
    }

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) {
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        return new SocketAdaptor(socketChannelImpl);
    }

    private class SocketInputStream
    extends ChannelInputStream {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = SocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!SocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (SocketAdaptor.this.timeout == 0) {
                    return SocketAdaptor.this.sc.read(byteBuffer);
                }
                SelectionKey selectionKey = null;
                SocketAdaptor.this.sc.configureBlocking(false);
                try {
                    long l;
                    int n = SocketAdaptor.this.sc.read(byteBuffer);
                    if (n != 0) {
                        int n2 = n;
                        Object var12_7 = null;
                        if (selectionKey != null) {
                            selectionKey.cancel();
                        }
                        if (!SocketAdaptor.this.sc.isOpen()) return n2;
                        SocketAdaptor.this.sc.configureBlocking(true);
                        return n2;
                    }
                    Selector selector = Util.getTemporarySelector(SocketAdaptor.this.sc);
                    selectionKey = SocketAdaptor.this.sc.register(selector, 1);
                    long l2 = SocketAdaptor.this.timeout;
                    do {
                        l = System.currentTimeMillis();
                        selector.select(l2);
                        if (selectionKey.isReadable() && (n = SocketAdaptor.this.sc.read(byteBuffer)) != 0) {
                            int n3 = n;
                            Object var12_8 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (!SocketAdaptor.this.sc.isOpen()) return n3;
                            SocketAdaptor.this.sc.configureBlocking(true);
                            return n3;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (!SocketAdaptor.this.sc.isOpen()) throw throwable;
                    SocketAdaptor.this.sc.configureBlocking(true);
                    throw throwable;
                }
            }
        }

        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }
    }
}

