/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.NetworkInterface;
import sun.nio.ch.SocketOpts;

class SocketOptsImpl
implements SocketOpts {
    private final Dispatcher d;

    public int linger() throws IOException {
        return this.getInt(128);
    }

    public int receiveBufferSize() throws IOException {
        return this.getInt(4098);
    }

    public int sendBufferSize() throws IOException {
        return this.getInt(4097);
    }

    public boolean broadcast() throws IOException {
        return this.getBoolean(32);
    }

    public boolean keepAlive() throws IOException {
        return this.getBoolean(8);
    }

    public boolean outOfBandInline() throws IOException {
        return this.getBoolean(4099);
    }

    public boolean reuseAddress() throws IOException {
        return this.getBoolean(4);
    }

    protected int getInt(int n) throws IOException {
        return this.d.getInt(n);
    }

    protected boolean getBoolean(int n) throws IOException {
        return this.d.getInt(n) > 0;
    }

    protected void setInt(int n, int n2) throws IOException {
        this.d.setInt(n, n2);
    }

    protected void setBoolean(int n, boolean bl) throws IOException {
        this.d.setInt(n, bl ? 1 : 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getInterfaces()[0].getName());
        stringBuffer.append('[');
        int n = stringBuffer.length();
        try {
            this.toString(stringBuffer);
        }
        catch (IOException iOException) {
            stringBuffer.setLength(n);
            stringBuffer.append("closed");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void toString(StringBuffer stringBuffer) throws IOException {
        int n;
        if (this.broadcast()) {
            this.addToString(stringBuffer, "broadcast");
        }
        if (this.keepAlive()) {
            this.addToString(stringBuffer, "keepalive");
        }
        if ((n = this.linger()) > 0) {
            this.addToString(stringBuffer, "linger=");
            this.addToString(stringBuffer, n);
        }
        if (this.outOfBandInline()) {
            this.addToString(stringBuffer, "oobinline");
        }
        if ((n = this.receiveBufferSize()) > 0) {
            this.addToString(stringBuffer, "rcvbuf=");
            this.addToString(stringBuffer, n);
        }
        if ((n = this.sendBufferSize()) > 0) {
            this.addToString(stringBuffer, "sndbuf=");
            this.addToString(stringBuffer, n);
        }
        if (this.reuseAddress()) {
            this.addToString(stringBuffer, "reuseaddr");
        }
    }

    protected void addToString(StringBuffer stringBuffer, int n) {
        this.addToString(stringBuffer, Integer.toString(n));
    }

    protected NetworkInterface getNetworkInterface(int n) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    protected void setNetworkInterface(int n, NetworkInterface networkInterface) throws IOException {
        throw new UnsupportedOperationException("NYI");
    }

    public SocketOpts linger(int n) throws IOException {
        this.setInt(128, n);
        return this;
    }

    public SocketOpts receiveBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setInt(4098, n);
        return this;
    }

    public SocketOpts sendBufferSize(int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setInt(4097, n);
        return this;
    }

    public SocketOpts broadcast(boolean bl) throws IOException {
        this.setBoolean(32, bl);
        return this;
    }

    public SocketOpts keepAlive(boolean bl) throws IOException {
        this.setBoolean(8, bl);
        return this;
    }

    public SocketOpts outOfBandInline(boolean bl) throws IOException {
        this.setBoolean(4099, bl);
        return this;
    }

    public SocketOpts reuseAddress(boolean bl) throws IOException {
        this.setBoolean(4, bl);
        return this;
    }

    SocketOptsImpl(Dispatcher dispatcher) {
        this.d = dispatcher;
    }

    protected void addToString(StringBuffer stringBuffer, String string) {
        char c = stringBuffer.charAt(stringBuffer.length() - 1);
        if (c != '[' && c != '=') {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
    }

    static abstract class Dispatcher {
        Dispatcher() {
        }

        abstract int getInt(int var1) throws IOException;

        abstract void setInt(int var1, int var2) throws IOException;
    }

    static class IP
    extends SocketOptsImpl
    implements SocketOpts.IP {
        public int typeOfService() throws IOException {
            return this.getInt(3);
        }

        public boolean multicastLoop() throws IOException {
            return this.getBoolean(18);
        }

        protected void toString(StringBuffer stringBuffer) throws IOException {
            super.toString(stringBuffer);
            int n = this.typeOfService();
            if (n > 0) {
                this.addToString(stringBuffer, "tos=");
                this.addToString(stringBuffer, n);
            }
        }

        public NetworkInterface multicastInterface() throws IOException {
            return this.getNetworkInterface(31);
        }

        public SocketOpts.IP typeOfService(int n) throws IOException {
            this.setInt(3, n);
            return this;
        }

        public SocketOpts.IP multicastLoop(boolean bl) throws IOException {
            this.setBoolean(18, bl);
            return this;
        }

        IP(Dispatcher dispatcher) {
            super(dispatcher);
        }

        public SocketOpts.IP multicastInterface(NetworkInterface networkInterface) throws IOException {
            this.setNetworkInterface(31, networkInterface);
            return this;
        }

        public static class TCP
        extends IP
        implements SocketOpts.IP.TCP {
            public boolean noDelay() throws IOException {
                return this.getBoolean(1);
            }

            protected void toString(StringBuffer stringBuffer) throws IOException {
                super.toString(stringBuffer);
                if (this.noDelay()) {
                    this.addToString(stringBuffer, "nodelay");
                }
            }

            public SocketOpts.IP.TCP noDelay(boolean bl) throws IOException {
                this.setBoolean(1, bl);
                return this;
            }

            TCP(Dispatcher dispatcher) {
                super(dispatcher);
            }
        }
    }
}

