/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;

public class AbstractCharsetProvider
extends CharsetProvider {
    private Map classMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map aliasMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map aliasNameMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private Map cache = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
    private String packagePrefix;

    protected AbstractCharsetProvider() {
        this.packagePrefix = "sun.nio.cs";
    }

    protected AbstractCharsetProvider(String string) {
        this.packagePrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator charsets() {
        ArrayList arrayList;
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            arrayList = new ArrayList(this.classMap.keySet());
        }
        return new Iterator(){
            Iterator i;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                String string = (String)this.i.next();
                return AbstractCharsetProvider.this.lookup(string);
            }
            {
                this.i = arrayList.iterator();
            }
        };
    }

    private String canonicalize(String string) {
        String string2 = (String)this.aliasMap.get(string);
        return string2 != null ? string2 : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] aliases(String string) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            return (String[])this.aliasNameMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Charset charsetForName(String string) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            return this.lookup(this.canonicalize(string));
        }
    }

    private Charset lookup(String string) {
        Object object;
        SoftReference softReference = (SoftReference)this.cache.get(string);
        if (softReference != null && (object = (Charset)softReference.get()) != null) {
            return object;
        }
        object = (String)this.classMap.get(string);
        if (object == null) {
            return null;
        }
        try {
            Class clazz = Class.forName(this.packagePrefix + "." + (String)object, true, this.getClass().getClassLoader());
            Charset charset = (Charset)clazz.newInstance();
            this.cache.put(string, new SoftReference(charset));
            return charset;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    private static void put(Map map, String string, Object object) {
        if (!map.containsKey(string)) {
            map.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void charset(String string, String string2, String[] stringArray) {
        AbstractCharsetProvider abstractCharsetProvider = this;
        synchronized (abstractCharsetProvider) {
            AbstractCharsetProvider.put(this.classMap, string, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                AbstractCharsetProvider.put(this.aliasMap, stringArray[i], string);
            }
            AbstractCharsetProvider.put(this.aliasNameMap, string, stringArray);
        }
    }
}

