/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !SingleByteEncoder.class.desiredAssertionStatus();
    }

    public byte encode(char c) {
        return (byte)this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
    }

    public boolean canEncode(char c) {
        char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
        return c2 != '\u0000';
    }

    protected SingleByteEncoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        super(charset, 1.0f, 1.0f);
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n;
        this.mask2 = n2;
        this.shift = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block15: {
            CoderResult coderResult2;
            block14: {
                CoderResult coderResult3;
                block13: {
                    CoderResult coderResult4;
                    block12: {
                        CoderResult coderResult5;
                        block11: {
                            CoderResult coderResult6;
                            block10: {
                                char[] cArray = charBuffer.array();
                                n2 = charBuffer.arrayOffset() + charBuffer.position();
                                int n3 = charBuffer.arrayOffset() + charBuffer.limit();
                                if (!$assertionsDisabled && n2 > n3) {
                                    throw new AssertionError();
                                }
                                byte[] byArray = byteBuffer.array();
                                n = byteBuffer.arrayOffset() + byteBuffer.position();
                                int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                if (!$assertionsDisabled && n > n4) {
                                    throw new AssertionError();
                                }
                                n = n <= n4 ? n : n4;
                                try {
                                    for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                                        char c = cArray[n2];
                                        if (Surrogate.is(c)) {
                                            if (this.sgp.parse(c, cArray, n2, n3) < 0) {
                                                coderResult6 = this.sgp.error();
                                                Object var13_16 = null;
                                                break block10;
                                            }
                                            coderResult5 = this.sgp.unmappableResult();
                                            break block11;
                                        }
                                        if (c >= '\ufffe') {
                                            coderResult4 = CoderResult.unmappableForLength(1);
                                            break block12;
                                        }
                                        if (n4 - n < 1) {
                                            coderResult3 = CoderResult.OVERFLOW;
                                            break block13;
                                        }
                                        char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                                        if (c2 == '\u0000' && c != '\u0000') {
                                            coderResult2 = CoderResult.unmappableForLength(1);
                                            break block14;
                                        }
                                        byArray[n++] = (byte)c2;
                                    }
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block15;
                                }
                                catch (Throwable throwable) {
                                    Object var13_22 = null;
                                    charBuffer.position(n2 - charBuffer.arrayOffset());
                                    byteBuffer.position(n - byteBuffer.arrayOffset());
                                    throw throwable;
                                }
                            }
                            charBuffer.position(n2 - charBuffer.arrayOffset());
                            byteBuffer.position(n - byteBuffer.arrayOffset());
                            return coderResult6;
                        }
                        Object var13_17 = null;
                        charBuffer.position(n2 - charBuffer.arrayOffset());
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        return coderResult5;
                    }
                    Object var13_18 = null;
                    charBuffer.position(n2 - charBuffer.arrayOffset());
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    return coderResult4;
                }
                Object var13_19 = null;
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n - byteBuffer.arrayOffset());
                return coderResult3;
            }
            Object var13_20 = null;
            charBuffer.position(n2 - charBuffer.arrayOffset());
            byteBuffer.position(n - byteBuffer.arrayOffset());
            return coderResult2;
        }
        Object var13_21 = null;
        charBuffer.position(n2 - charBuffer.arrayOffset());
        byteBuffer.position(n - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                if (c2 == '\u0000' && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++n;
                byteBuffer.put((byte)c2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

