/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Surrogate {
    public static final char MIN_HIGH = '\ud800';
    public static final char MAX_HIGH = '\udbff';
    public static final char MIN_LOW = '\udc00';
    public static final char MAX_LOW = '\udfff';
    public static final char MIN = '\ud800';
    public static final char MAX = '\udfff';
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !Surrogate.class.desiredAssertionStatus();
    }

    private Surrogate() {
    }

    public static int toUCS4(char c, char c2) {
        if (!($assertionsDisabled || Surrogate.isHigh(c) && Surrogate.isLow(c2))) {
            throw new AssertionError();
        }
        return ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
    }

    public static char high(int n) {
        if (!$assertionsDisabled && !Surrogate.neededFor(n)) {
            throw new AssertionError();
        }
        return (char)(0xD800 | n - 65536 >> 10 & 0x3FF);
    }

    public static char low(int n) {
        if (!$assertionsDisabled && !Surrogate.neededFor(n)) {
            throw new AssertionError();
        }
        return (char)(0xDC00 | n - 65536 & 0x3FF);
    }

    public static boolean is(int n) {
        return 55296 <= n && n <= 57343;
    }

    public static boolean isHigh(int n) {
        return 55296 <= n && n <= 56319;
    }

    public static boolean isLow(int n) {
        return 56320 <= n && n <= 57343;
    }

    public static boolean neededFor(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static class Generator {
        private CoderResult error = CoderResult.OVERFLOW;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$cs$Surrogate == null ? (class$sun$nio$cs$Surrogate = Surrogate.class$("sun.nio.cs.Surrogate")) : class$sun$nio$cs$Surrogate).desiredAssertionStatus();
        }

        public int generate(int n, int n2, char[] cArray, int n3, int n4) {
            if (n <= 65535) {
                if (Surrogate.is(n)) {
                    this.error = CoderResult.malformedForLength(n2);
                    return -1;
                }
                if (n4 - n3 < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n3] = (char)n;
                this.error = null;
                return 1;
            }
            if (n < 65536) {
                this.error = CoderResult.malformedForLength(n2);
                return -1;
            }
            if (n <= 0x10FFFF) {
                if (n4 - n3 < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                cArray[n3] = Surrogate.high(n);
                cArray[n3 + 1] = Surrogate.low(n);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n2);
            return -1;
        }

        public int generate(int n, int n2, CharBuffer charBuffer) {
            if (n <= 65535) {
                if (Surrogate.is(n)) {
                    this.error = CoderResult.malformedForLength(n2);
                    return -1;
                }
                if (charBuffer.remaining() < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put((char)n);
                this.error = null;
                return 1;
            }
            if (n < 65536) {
                this.error = CoderResult.malformedForLength(n2);
                return -1;
            }
            if (n <= 0x10FFFF) {
                if (charBuffer.remaining() < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                charBuffer.put(Surrogate.high(n));
                charBuffer.put(Surrogate.low(n));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(n2);
            return -1;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw new AssertionError();
            }
            return this.error;
        }
    }

    public static class Parser {
        private int character;
        private CoderResult error = CoderResult.UNDERFLOW;
        private boolean isPair;
        static final /* synthetic */ boolean $assertionsDisabled;

        public int character() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.character;
        }

        public int increment() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.isPair ? 2 : 1;
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$Surrogate == null ? (class$sun$nio$cs$Surrogate = Surrogate.class$("sun.nio.cs.Surrogate")) : class$sun$nio$cs$Surrogate).desiredAssertionStatus();
        }

        public boolean isPair() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return this.isPair;
        }

        public int parse(char c, char[] cArray, int n, int n2) {
            if (!$assertionsDisabled && cArray[n] != c) {
                throw new AssertionError();
            }
            if (Surrogate.isHigh(c)) {
                if (n2 - n < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = cArray[n + 1];
                if (Surrogate.isLow(c2)) {
                    this.character = Surrogate.toUCS4(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Surrogate.isLow(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public int parse(char c, CharBuffer charBuffer) {
            if (Surrogate.isHigh(c)) {
                if (!charBuffer.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = charBuffer.get();
                if (Surrogate.isLow(c2)) {
                    this.character = Surrogate.toUCS4(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Surrogate.isLow(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public CoderResult error() {
            if (!$assertionsDisabled && this.error == null) {
                throw new AssertionError();
            }
            return this.error;
        }

        public CoderResult unmappableResult() {
            if (!$assertionsDisabled && this.error != null) {
                throw new AssertionError();
            }
            return CoderResult.unmappableForLength(this.isPair ? 2 : 1);
        }
    }
}

