/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;

public class US_ASCII
extends Charset
implements HistoricallyNamedCharset {
    static /* synthetic */ Class class$sun$nio$cs$US_ASCII;

    public US_ASCII() {
        super("US-ASCII", StandardCharsets.aliasesFor("US-ASCII"));
    }

    public String historicalName() {
        return "ASCII";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends CharsetDecoder {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$cs$US_ASCII == null ? (class$sun$nio$cs$US_ASCII = US_ASCII.class$("sun.nio.cs.US_ASCII")) : class$sun$nio$cs$US_ASCII).desiredAssertionStatus();
        }

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            int n2;
            block10: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        byte[] byArray = byteBuffer.array();
                        n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
                        if (!$assertionsDisabled && n2 > n3) {
                            throw new AssertionError();
                        }
                        char[] cArray = charBuffer.array();
                        n = charBuffer.arrayOffset() + charBuffer.position();
                        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                        if (!$assertionsDisabled && n > n4) {
                            throw new AssertionError();
                        }
                        n = n <= n4 ? n : n4;
                        try {
                            for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                                byte by = byArray[n2];
                                if (by >= 0) {
                                    if (n >= n4) {
                                        coderResult3 = CoderResult.OVERFLOW;
                                        Object var12_13 = null;
                                        break block8;
                                    } else {
                                        cArray[n++] = (char)by;
                                        continue;
                                    }
                                }
                                coderResult2 = CoderResult.malformedForLength(1);
                                break block9;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var12_16 = null;
                            byteBuffer.position(n2 - byteBuffer.arrayOffset());
                            charBuffer.position(n - charBuffer.arrayOffset());
                            throw throwable;
                        }
                    }
                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                    charBuffer.position(n - charBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var12_14 = null;
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n - charBuffer.arrayOffset());
                return coderResult2;
            }
            Object var12_15 = null;
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n - charBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (by >= 0) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)by);
                        ++n;
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$cs$US_ASCII == null ? (class$sun$nio$cs$US_ASCII = US_ASCII.class$("sun.nio.cs.US_ASCII")) : class$sun$nio$cs$US_ASCII).desiredAssertionStatus();
        }

        public boolean canEncode(char c) {
            return c < '\u0080';
        }

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            int n2;
            block12: {
                CoderResult coderResult2;
                block11: {
                    CoderResult coderResult3;
                    block10: {
                        CoderResult coderResult4;
                        block9: {
                            char[] cArray = charBuffer.array();
                            n2 = charBuffer.arrayOffset() + charBuffer.position();
                            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
                            if (!$assertionsDisabled && n2 > n3) {
                                throw new AssertionError();
                            }
                            byte[] byArray = byteBuffer.array();
                            n = byteBuffer.arrayOffset() + byteBuffer.position();
                            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
                            if (!$assertionsDisabled && n > n4) {
                                throw new AssertionError();
                            }
                            n = n <= n4 ? n : n4;
                            try {
                                for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2, ++n) {
                                    char c = cArray[n2];
                                    if (c < '\u0080') {
                                        if (n >= n4) {
                                            coderResult4 = CoderResult.OVERFLOW;
                                            Object var12_14 = null;
                                            break block9;
                                        } else {
                                            byArray[n] = (byte)c;
                                            continue;
                                        }
                                    }
                                    if (this.sgp.parse(c, cArray, n2, n3) < 0) {
                                        coderResult3 = this.sgp.error();
                                        break block10;
                                    }
                                    coderResult2 = this.sgp.unmappableResult();
                                    break block11;
                                }
                                coderResult = CoderResult.UNDERFLOW;
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var12_18 = null;
                                charBuffer.position(n2 - charBuffer.arrayOffset());
                                byteBuffer.position(n - byteBuffer.arrayOffset());
                                throw throwable;
                            }
                        }
                        charBuffer.position(n2 - charBuffer.arrayOffset());
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        return coderResult4;
                    }
                    Object var12_15 = null;
                    charBuffer.position(n2 - charBuffer.arrayOffset());
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    return coderResult3;
                }
                Object var12_16 = null;
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n - byteBuffer.arrayOffset());
                return coderResult2;
            }
            Object var12_17 = null;
            charBuffer.position(n2 - charBuffer.arrayOffset());
            byteBuffer.position(n - byteBuffer.arrayOffset());
            return coderResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (c < '\u0080') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        ++n;
                        continue;
                    }
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

