/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.sun.security.auth.PrincipalComparator;
import java.awt.AWTPermission;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.PolicyInfo;
import sun.security.provider.PolicyParser;
import sun.security.provider.SelfPermission;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;
import sun.security.util.SecurityConstants;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private static final String SELF = "${{self}}";
    private static final String X500PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final String POLICY = "java.security.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final int DEFAULT_CACHE_SIZE = 1;
    private static IdentityScope scope = null;
    private PolicyInfo policyInfo;
    private boolean constructed = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private boolean allowSystemProperties = true;
    private boolean notUtf8 = false;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    public PolicyFile() {
        this.init();
    }

    private void init() {
        int n;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyFile.this.expandProperties = "true".equalsIgnoreCase(Security.getProperty("policy.expandProperties"));
                PolicyFile.this.ignoreIdentityScope = "true".equalsIgnoreCase(Security.getProperty("policy.ignoreIdentityScope"));
                PolicyFile.this.allowSystemProperties = "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty"));
                PolicyFile.this.notUtf8 = "false".equalsIgnoreCase(System.getProperty("sun.security.policy.utf8"));
                return System.getProperty("sun.security.policy.numcaches");
            }
        });
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
        } else {
            n = 1;
        }
        PolicyInfo policyInfo = new PolicyInfo(n);
        this.initPolicyFile(policyInfo);
        this.policyInfo = policyInfo;
    }

    public void refresh() {
        this.init();
    }

    private static boolean isTrusted(Identity identity) {
        SystemSigner systemSigner;
        SystemIdentity systemIdentity;
        return identity instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)identity).isTrusted() : identity instanceof SystemSigner && (systemSigner = (SystemSigner)identity).isTrusted();
    }

    private void initPolicyFile(PolicyInfo policyInfo) {
        boolean bl = this.initPolicyFile(POLICY, POLICY_URL, policyInfo);
        if (!bl) {
            this.initStaticPolicy(policyInfo);
        }
        this.initPolicyFile(AUTH_POLICY, AUTH_POLICY_URL, policyInfo);
    }

    private void initStaticPolicy(final PolicyInfo policyInfo) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, null));
                policyEntry.add(SecurityConstants.LOCAL_LISTEN_PERMISSION);
                policyEntry.add(new PropertyPermission("java.version", "read"));
                policyEntry.add(new PropertyPermission("java.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vendor.url", "read"));
                policyEntry.add(new PropertyPermission("java.class.version", "read"));
                policyEntry.add(new PropertyPermission("os.name", "read"));
                policyEntry.add(new PropertyPermission("os.version", "read"));
                policyEntry.add(new PropertyPermission("os.arch", "read"));
                policyEntry.add(new PropertyPermission("file.separator", "read"));
                policyEntry.add(new PropertyPermission("path.separator", "read"));
                policyEntry.add(new PropertyPermission("line.separator", "read"));
                policyEntry.add(new PropertyPermission("java.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.name", "read"));
                policyInfo.policyEntries.add(policyEntry);
                try {
                    File file = new File(PropertyExpander.expand("${java.home}/lib/ext/*"));
                    policyEntry = new PolicyEntry(new CodeSource(ParseUtil.fileToEncodedURL(file), null));
                    policyEntry.add(SecurityConstants.ALL_PERMISSION);
                    policyInfo.policyEntries.add(policyEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    private String printPD(ProtectionDomain protectionDomain) {
        Principal[] principalArray = protectionDomain.getPrincipals();
        String string = "<no principals>";
        if (principalArray != null && principalArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("(principals ");
            for (int i = 0; i < principalArray.length; ++i) {
                stringBuffer.append(principalArray[i].getClass().getName() + " \"" + principalArray[i].getName() + "\"");
                if (i < principalArray.length - 1) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        return "PD CodeSource: " + protectionDomain.getCodeSource() + "\n\t" + "PD ClassLoader: " + protectionDomain.getClassLoader() + "\n\t" + "PD Principals: " + string;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block17: {
            Serializable serializable;
            String string = null;
            codeSource2 = codeSource;
            URL uRL = codeSource.getLocation();
            if (uRL != null) {
                try {
                    serializable = uRL.openConnection().getPermission();
                }
                catch (IOException iOException) {
                    serializable = null;
                }
                if (serializable instanceof FilePermission) {
                    string = serializable.getName();
                } else if (serializable == null && uRL.getProtocol().equals("file")) {
                    string = uRL.getFile().replace('/', File.separatorChar);
                    string = ParseUtil.decode(string);
                }
            }
            if (string != null) {
                try {
                    serializable = null;
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                        boolean bl2 = false;
                        if (string.endsWith(File.separator)) {
                            bl2 = true;
                        }
                        if (string.equals("")) {
                            string = System.getProperty("user.dir");
                        }
                        File file = new File(string);
                        string = file.getCanonicalPath();
                        StringBuffer stringBuffer = new StringBuffer(string);
                        if (!string.endsWith(File.separator) && (bl2 || file.isDirectory())) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append('*');
                        string = stringBuffer.toString();
                    } else {
                        string = new File(string).getCanonicalPath();
                    }
                    serializable = ParseUtil.fileToEncodedURL(new File(string));
                    if (bl) {
                        codeSource2 = new CodeSource((URL)serializable, this.getSignerCertificates(codeSource));
                        break block17;
                    }
                    codeSource2 = new CodeSource((URL)serializable, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block17;
                }
            }
            if (bl) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    private boolean replacePrincipals(List list, KeyStore keyStore) {
        if (list == null || list.size() == 0 || keyStore == null) {
            return true;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("PolicyParser.REPLACE_NAME")) continue;
            String string = this.getDN(principalEntry.principalName, keyStore);
            if (string == null) {
                return false;
            }
            if (debug != null) {
                debug.println("  Replacing \"" + principalEntry.principalName + "\" with " + X500PRINCIPAL + "/\"" + string + "\"");
            }
            principalEntry.principalClass = X500PRINCIPAL;
            principalEntry.principalName = string;
        }
        return true;
    }

    private void expandPermissionName(PolicyParser.PermissionEntry permissionEntry, KeyStore keyStore) throws Exception {
        int n;
        int n2;
        if (permissionEntry.name == null || permissionEntry.name.indexOf("${{", 0) == -1) {
            return;
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = permissionEntry.name.indexOf("${{", n3)) != -1 && (n = permissionEntry.name.indexOf("}}", n2)) >= 1) {
            String string;
            stringBuffer.append(permissionEntry.name.substring(n3, n2));
            String string2 = string = permissionEntry.name.substring(n2 + 3, n);
            int n4 = string.indexOf(":");
            if (n4 != -1) {
                string2 = string.substring(0, n4);
            }
            if (string2.equalsIgnoreCase("self")) {
                stringBuffer.append(permissionEntry.name.substring(n2, n + 2));
                n3 = n + 2;
                continue;
            }
            if (string2.equalsIgnoreCase("alias")) {
                if (n4 == -1) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("alias name not provided (pe.name)"));
                    Object[] objectArray = new Object[]{permissionEntry.name};
                    throw new Exception(messageFormat.format(objectArray));
                }
                String string3 = string.substring(n4 + 1);
                if ((string3 = this.getDN(string3, keyStore)) == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("unable to perform substitution on alias, suffix"));
                    Object[] objectArray = new Object[]{string.substring(n4 + 1)};
                    throw new Exception(messageFormat.format(objectArray));
                }
                stringBuffer.append("javax.security.auth.x500.X500Principal \"" + string3 + "\"");
                n3 = n + 2;
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("substitution value, prefix, unsupported"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        stringBuffer.append(permissionEntry.name.substring(n3));
        if (debug != null) {
            debug.println("  Permission name expanded from:\n\t" + permissionEntry.name + "\nto\n\t" + stringBuffer.toString());
        }
        permissionEntry.name = stringBuffer.toString();
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        Map map = this.policyInfo.getPdMapping();
        PermissionCollection permissionCollection = (PermissionCollection)map.get(protectionDomain);
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        map.put(protectionDomain, permissionCollection);
        return permissionCollection.implies(permission);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.getPermissions(new Permissions(), codeSource);
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Permissions permissions = new Permissions();
        if (protectionDomain == null) {
            return permissions;
        }
        this.getPermissions(permissions, protectionDomain);
        PermissionCollection permissionCollection = protectionDomain.getPermissions();
        if (permissionCollection != null) {
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permissions.add((Permission)enumeration.nextElement());
            }
        }
        return permissions;
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        int n;
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        for (n = 0; n < certificateArray.length; ++n) {
            if (certificateArray[n] instanceof X509Certificate) continue;
            return codeSource.getCertificates();
        }
        int n2 = 0;
        for (n = 0; n < certificateArray.length; ++n) {
            ++n2;
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        if (n2 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < certificateArray.length; ++n) {
            arrayList.add(certificateArray[n]);
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        Object[] objectArray = new Certificate[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private boolean init(URL uRL, PolicyInfo policyInfo) {
        boolean bl;
        block5: {
            bl = false;
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = this.notUtf8 ? new InputStreamReader(this.getInputStream(uRL)) : new InputStreamReader(this.getInputStream(uRL), "UTF-8");
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore, policyInfo);
                }
                bl = true;
            }
            catch (PolicyParser.ParsingException parsingException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("java.security.policy: error parsing policy:\n\tmessage"));
                Object[] objectArray = new Object[]{uRL, parsingException.getLocalizedMessage()};
                System.err.println(messageFormat.format(objectArray));
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForTrustedIdentity(final Certificate certificate, PolicyInfo policyInfo) {
        Certificate[] certificateArray;
        if (certificate == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        Serializable serializable = PolicyFile.class;
        synchronized (serializable) {
            if (scope == null && (certificateArray = (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return IdentityScope.getSystemScope();
                }
            })) instanceof IdentityDatabase) {
                scope = certificateArray;
            }
        }
        if (scope == null) {
            this.ignoreIdentityScope = true;
            return false;
        }
        serializable = (Identity)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return scope.getIdentity(certificate.getPublicKey());
            }
        });
        if (PolicyFile.isTrusted((Identity)serializable)) {
            if (debug != null) {
                debug.println("Adding policy entry for trusted Identity: ");
                AccessController.doPrivileged(new PrivilegedAction((Identity)serializable){
                    private final /* synthetic */ Identity val$id;

                    public Object run() {
                        debug.println("  identity = " + this.val$id);
                        return null;
                    }
                    {
                        this.val$id = identity;
                    }
                });
                debug.println("");
            }
            certificateArray = new Certificate[]{certificate};
            PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, certificateArray));
            policyEntry.add(SecurityConstants.ALL_PERMISSION);
            Object object = policyInfo.identityPolicyEntries;
            synchronized (object) {
                policyInfo.identityPolicyEntries.add(policyEntry);
            }
            object = policyInfo.aliasMapping;
            synchronized (object) {
                policyInfo.aliasMapping.put(certificate, ((Identity)serializable).getName());
            }
            return true;
        }
        return false;
    }

    private boolean subjectListImpliesPrincipalEntry(List list, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalClass.equals(principalEntry2.principalClass) || !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.principalName.equals(principalEntry2.principalName)) continue;
            return true;
        }
        return false;
    }

    private String getDN(String string, KeyStore keyStore) {
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("  Error retrieving certificate for '" + string + "': " + exception.toString());
            }
            return null;
        }
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.println("  -- No certificate for '" + string + "' - ignoring entry");
            }
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        X500Principal x500Principal = new X500Principal(x509Certificate.getSubjectX500Principal().toString());
        return x500Principal.getName();
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, Principal[] principalArray) {
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = principalEntry.principalClass;
            stringArray[0][1] = principalEntry.principalName;
            return stringArray;
        }
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            LinkedList linkedList = new LinkedList();
            for (int i = 0; i < principalArray.length; ++i) {
                if (!principalEntry.principalClass.equals(principalArray[i].getClass().getName())) continue;
                linkedList.add(principalArray[i]);
            }
            String[][] stringArray = new String[linkedList.size()][2];
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                stringArray[n][0] = principal.getClass().getName();
                stringArray[n][1] = principal.getName();
                ++n;
            }
            return stringArray;
        }
        String[][] stringArray = new String[principalArray.length][2];
        for (int i = 0; i < principalArray.length; ++i) {
            stringArray[i][0] = principalArray[i].getClass().getName();
            stringArray[i][1] = principalArray[i].getName();
        }
        return stringArray;
    }

    private PermissionCollection getPermissions(Permissions permissions, final CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PolicyFile.this.canonicalizeCodebase(codeSource, true);
            }
        });
        return this.getPermissions(permissions, codeSource2, null);
    }

    private PermissionCollection getPermissions(Permissions permissions, ProtectionDomain protectionDomain) {
        CodeSource codeSource;
        if (debug != null) {
            debug.println("getPermissions:\n\t" + this.printPD(protectionDomain));
        }
        if ((codeSource = protectionDomain.getCodeSource()) == null) {
            return permissions;
        }
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PolicyFile.this.canonicalizeCodebase(codeSource, true);
            }
        });
        return this.getPermissions(permissions, codeSource2, protectionDomain.getPrincipals());
    }

    private boolean initPolicyFile(final String string, final String string2, final PolicyInfo policyInfo) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string3;
                URL uRL;
                Object object;
                String string22;
                boolean bl = false;
                if (PolicyFile.this.allowSystemProperties && (string22 = System.getProperty(string)) != null) {
                    boolean bl2;
                    block13: {
                        bl2 = false;
                        if (string22.startsWith("=")) {
                            bl2 = true;
                            string22 = string22.substring(1);
                        }
                        try {
                            string22 = PropertyExpander.expand(string22);
                            object = new File(string22);
                            uRL = ((File)object).exists() ? ParseUtil.fileToEncodedURL(new File(((File)object).getCanonicalPath())) : new URL(string22);
                            if (debug != null) {
                                debug.println("reading " + uRL);
                            }
                            if (PolicyFile.this.init(uRL, policyInfo)) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            if (debug == null) break block13;
                            debug.println("caught exception: " + exception);
                        }
                    }
                    if (bl2) {
                        if (debug != null) {
                            debug.println("overriding other policies!");
                        }
                        return bl;
                    }
                }
                int n = 1;
                while ((string3 = Security.getProperty(string2 + n)) != null) {
                    block14: {
                        try {
                            uRL = null;
                            object = PropertyExpander.expand(string3).replace(File.separatorChar, '/');
                            uRL = string3.startsWith("file:${java.home}/") || string3.startsWith("file:${user.home}/") ? new File(((String)object).substring(5)).toURI().toURL() : new URI((String)object).toURL();
                            if (debug != null) {
                                debug.println("reading " + uRL);
                            }
                            if (PolicyFile.this.init(uRL, policyInfo)) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            if (debug == null) break block14;
                            debug.println("error reading policy " + exception);
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
                return bl;
            }
        });
        return bl;
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) {
        Object object;
        Object object2;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            if (grantEntry.principals != null && grantEntry.principals.size() > 0) {
                object2 = grantEntry.principals.listIterator();
                while (object2.hasNext()) {
                    object = (PolicyParser.PrincipalEntry)object2.next();
                    debug.println("  " + ((PolicyParser.PrincipalEntry)object).toString());
                }
            }
        }
        try {
            object2 = this.getCodeSource(grantEntry, keyStore, policyInfo);
            if (object2 == null) {
                return;
            }
            if (!this.replacePrincipals(grantEntry.principals, keyStore)) {
                return;
            }
            object = new PolicyEntry((CodeSource)object2, grantEntry.principals);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                Object object3;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    Permission permission;
                    this.expandPermissionName(permissionEntry, keyStore);
                    if (permissionEntry.permission.equals("javax.security.auth.PrivateCredentialPermission") && permissionEntry.name.endsWith(" self")) {
                        permissionEntry.name = permissionEntry.name.substring(0, permissionEntry.name.indexOf("self")) + SELF;
                    }
                    if (permissionEntry.name != null && permissionEntry.name.indexOf(SELF) != -1) {
                        object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                        permission = new SelfPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    } else {
                        permission = PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    }
                    ((PolicyEntry)object).add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                    if (object3 == null && permissionEntry.signedBy != null) continue;
                    objectArray = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    ((PolicyEntry)object).add((Permission)objectArray);
                    if (debug == null) continue;
                    debug.println("  " + objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, invocationTargetException.getTargetException().toString()};
                    System.err.println(object3.format(objectArray));
                }
                catch (Exception exception) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, exception.toString()};
                    System.err.println(object3.format(objectArray));
                }
            }
            policyInfo.policyEntries.add(object);
        }
        catch (Exception exception) {
            object = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Entry:\n\tmessage"));
            Object[] objectArray = new Object[]{exception.toString()};
            System.err.println(((Format)object).format(objectArray));
        }
        if (debug != null) {
            debug.println();
        }
    }

    private CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy, policyInfo)) == null) {
            if (debug != null) {
                debug.println("  -- No certs for alias '" + grantEntry.signedBy + "' - ignoring entry");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private static final Permission getKnownInstance(Class clazz, String string, String string2) {
        if (clazz.equals(FilePermission.class)) {
            return new FilePermission(string, string2);
        }
        if (clazz.equals(SocketPermission.class)) {
            return new SocketPermission(string, string2);
        }
        if (clazz.equals(RuntimePermission.class)) {
            return new RuntimePermission(string, string2);
        }
        if (clazz.equals(PropertyPermission.class)) {
            return new PropertyPermission(string, string2);
        }
        if (clazz.equals(NetPermission.class)) {
            return new NetPermission(string, string2);
        }
        if (clazz.equals(AllPermission.class)) {
            return SecurityConstants.ALL_PERMISSION;
        }
        if (clazz.equals(AWTPermission.class)) {
            return new AWTPermission(string, string2);
        }
        return null;
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class clazz = Class.forName(string);
        Permission permission = PolicyFile.getKnownInstance(clazz, string2, string3);
        if (permission != null) {
            return permission;
        }
        if (string2 == null && string3 == null) {
            try {
                Constructor constructor = clazz.getConstructor(PARAMS0);
                return (Permission)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS1);
                    return (Permission)constructor.newInstance(new Object[]{string2});
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Constructor constructor = clazz.getConstructor(PARAMS2);
                    return (Permission)constructor.newInstance(new Object[]{string2, string3});
                }
            }
        }
        if (string2 != null && string3 == null) {
            try {
                Constructor constructor = clazz.getConstructor(PARAMS1);
                return (Permission)constructor.newInstance(new Object[]{string2});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor constructor = clazz.getConstructor(PARAMS2);
                return (Permission)constructor.newInstance(new Object[]{string2, string3});
            }
        }
        Constructor constructor = clazz.getConstructor(PARAMS2);
        return (Permission)constructor.newInstance(new Object[]{string2, string3});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permissions getPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray) {
        PolicyEntry policyEntry;
        int n = this.policyInfo.policyEntries.size();
        for (int i = 0; i < n; ++i) {
            policyEntry = (PolicyEntry)this.policyInfo.policyEntries.get(i);
            this.addPermissions(permissions, codeSource, principalArray, policyEntry);
        }
        Certificate[] certificateArray = this.policyInfo.identityPolicyEntries;
        synchronized (this.policyInfo.identityPolicyEntries) {
            int n2;
            n = this.policyInfo.identityPolicyEntries.size();
            for (n2 = 0; n2 < n; ++n2) {
                policyEntry = (PolicyEntry)this.policyInfo.identityPolicyEntries.get(n2);
                this.addPermissions(permissions, codeSource, principalArray, policyEntry);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (!this.ignoreIdentityScope && (certificateArray = codeSource.getCertificates()) != null) {
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    Object object;
                    Map map = this.policyInfo.aliasMapping;
                    synchronized (map) {
                        object = this.policyInfo.aliasMapping.get(certificateArray[n2]);
                    }
                    if (object != null || !this.checkForTrustedIdentity(certificateArray[n2], this.policyInfo)) continue;
                    permissions.add(SecurityConstants.ALL_PERMISSION);
                }
            }
            return permissions;
        }
    }

    private void expandSelf(SelfPermission selfPermission, List list, Principal[] principalArray, Permissions permissions) {
        block18: {
            Object object;
            Object object2;
            int n;
            if (list == null || list.size() == 0) {
                if (debug != null) {
                    debug.println("Ignoring permission " + selfPermission.getSelfType() + " with target name (" + selfPermission.getSelfName() + ").  " + "No Principal(s) specified " + "in the grant clause.  " + "SELF-based target names are " + "only valid in the context " + "of a Principal-based grant entry.");
                }
                return;
            }
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = selfPermission.getSelfName().indexOf(SELF, n2)) != -1) {
                stringBuffer.append(selfPermission.getSelfName().substring(n2, n));
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    object2 = (PolicyParser.PrincipalEntry)listIterator.next();
                    object = this.getPrincipalInfo((PolicyParser.PrincipalEntry)object2, principalArray);
                    for (int i = 0; i < ((String[][])object).length; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(object[i][0] + " " + "\"" + object[i][1] + "\"");
                    }
                    if (!listIterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                n2 = n + SELF.length();
            }
            stringBuffer.append(selfPermission.getSelfName().substring(n2));
            if (debug != null) {
                debug.println("  expanded:\n\t" + selfPermission.getSelfName() + "\n  into:\n\t" + stringBuffer.toString());
            }
            try {
                permissions.add(PolicyFile.getInstance(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = permissions.elements();
                object = null;
                while (object2.hasMoreElements()) {
                    Permission permission = (Permission)object2.nextElement();
                    if (!permission.getClass().getName().equals(selfPermission.getSelfType())) continue;
                    object = permission.getClass();
                    break;
                }
                if (object == null) {
                    permissions.add(new UnresolvedPermission(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions(), selfPermission.getCerts()));
                }
                try {
                    if (selfPermission.getSelfActions() == null) {
                        try {
                            Constructor constructor = object.getConstructor(PARAMS1);
                            permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString()}));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Constructor constructor = object.getConstructor(PARAMS2);
                            permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString(), selfPermission.getSelfActions()}));
                        }
                    }
                    Constructor constructor = object.getConstructor(PARAMS2);
                    permissions.add((Permission)constructor.newInstance(new Object[]{stringBuffer.toString(), selfPermission.getSelfActions()}));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("self entry expansion  instantiation failed: " + exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (debug == null) break block18;
                debug.println(exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] getCertificates(KeyStore keyStore, String string, PolicyInfo policyInfo) {
        Object[] objectArray;
        List list = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n;
            Certificate certificate = null;
            Map map = policyInfo.aliasMapping;
            synchronized (map) {
                certificate = (Certificate)policyInfo.aliasMapping.get(objectArray);
                if (certificate == null && keyStore != null) {
                    try {
                        certificate = keyStore.getCertificate((String)objectArray);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    if (certificate != null) {
                        policyInfo.aliasMapping.put(objectArray, certificate);
                        policyInfo.aliasMapping.put(certificate, objectArray);
                    }
                }
            }
            if (certificate == null) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(certificate);
        }
        if (list != null && n == list.size()) {
            objectArray = new Certificate[list.size()];
            list.toArray(objectArray);
            return objectArray;
        }
        return null;
    }

    private void addPermissions(Permissions permissions, final CodeSource codeSource, Principal[] principalArray, final PolicyEntry policyEntry) {
        Boolean bl;
        boolean bl2 = false;
        if (debug != null) {
            debug.println("evaluate codesources:\n\tPolicy CodeSource: " + policyEntry.getCodeSource() + "\n" + "\tActive CodeSource: " + codeSource);
        }
        if (!(bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(policyEntry.getCodeSource().implies(codeSource));
            }
        })).booleanValue()) {
            if (debug != null) {
                debug.println("evaluation (codesource) failed");
            }
        } else {
            Object object;
            final Principal[] principalArray2 = principalArray;
            List list = policyEntry.getPrincipals();
            LinkedList linkedList = new LinkedList();
            if (principalArray2 != null && principalArray2.length != 0) {
                object = null;
                for (int i = 0; i < principalArray2.length; ++i) {
                    object = new PolicyParser.PrincipalEntry(principalArray2[i].getClass().getName(), principalArray2[i].getName());
                    linkedList.add(object);
                }
            }
            if (debug != null) {
                debug.println("evaluate principals:\n\tPolicy Principals: " + list + "\n" + "\tActive Principals: " + linkedList);
            }
            if (list == null || list.size() == 0) {
                bl2 = true;
            } else if (linkedList.size() != 0) {
                object = list.listIterator(0);
                while (object.hasNext()) {
                    PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object.next();
                    try {
                        Class clazz = Class.forName(principalEntry.principalClass, true, Thread.currentThread().getContextClassLoader());
                        Constructor constructor = clazz.getConstructor(PARAMS1);
                        PrincipalComparator principalComparator = (PrincipalComparator)constructor.newInstance(new Object[]{principalEntry.principalName});
                        if (debug != null) {
                            debug.println("found PrincipalComparator " + principalComparator.getClass().getName());
                        }
                        final Subject subject = new Subject();
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Set<Principal> set = subject.getPrincipals();
                                for (int i = 0; i < principalArray2.length; ++i) {
                                    set.add((Object)principalArray2[i]);
                                }
                                return null;
                            }
                        });
                        bl2 = principalComparator.implies(subject);
                        if (bl2) continue;
                    }
                    catch (Exception exception) {
                        if (debug != null) {
                            debug.println("Exception while attempting to construct PrincipalComparator");
                            exception.printStackTrace();
                        }
                        if (bl2 = this.subjectListImpliesPrincipalEntry(linkedList, principalEntry)) continue;
                    }
                    break;
                }
            }
            if (!bl2) {
                if (debug != null) {
                    debug.println("evaluation failed");
                }
            } else {
                if (debug != null) {
                    debug.println("evaluation (codesource/principals) passed");
                }
                for (int i = 0; i < policyEntry.permissions.size(); ++i) {
                    Permission permission = (Permission)policyEntry.permissions.get(i);
                    if (debug != null) {
                        debug.println("  granting " + permission);
                    }
                    if (permission instanceof SelfPermission) {
                        this.expandSelf((SelfPermission)permission, list, principalArray2, permissions);
                        continue;
                    }
                    permissions.add(permission);
                }
            }
        }
    }

    private static class PolicyEntry {
        private final CodeSource codesource;
        final List permissions;
        private final List principals;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ResourcesMgr.getString("("));
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            for (int i = 0; i < this.permissions.size(); ++i) {
                Permission permission = (Permission)this.permissions.get(i);
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(permission);
                stringBuffer.append(ResourcesMgr.getString("\n"));
            }
            stringBuffer.append(ResourcesMgr.getString(")"));
            stringBuffer.append(ResourcesMgr.getString("\n"));
            return stringBuffer.toString();
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        PolicyEntry(CodeSource codeSource) {
            this(codeSource, null);
        }

        void add(Permission permission) {
            this.permissions.add(permission);
        }

        List getPrincipals() {
            return this.principals;
        }

        PolicyEntry(CodeSource codeSource, List list) {
            this.codesource = codeSource;
            this.permissions = new ArrayList();
            this.principals = list;
        }
    }
}

