/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

class KeyChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int keyCertSign = 5;
    private final int certPathLen;
    private CertSelector targetConstraints;
    private int remainingCerts;
    private Set supportedExts;

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.remainingCerts = this.certPathLen;
    }

    KeyChecker(int n, CertSelector certSelector) throws CertPathValidatorException {
        this.certPathLen = n;
        this.targetConstraints = certSelector;
        this.init(false);
    }

    static void verifyCAKeyUsage(X509Certificate x509Certificate) throws CertPathValidatorException {
        boolean[] blArray;
        String string = "CA key usage";
        if (debug != null) {
            debug.println("KeyChecker.verifyCAKeyUsage() ---checking " + string + "...");
        }
        if ((blArray = x509Certificate.getKeyUsage()) == null) {
            return;
        }
        if (!blArray[5]) {
            throw new CertPathValidatorException(string + " check failed: " + "keyCertSign bit is not set");
        }
        if (debug != null) {
            debug.println("KeyChecker.verifyCAKeyUsage() " + string + " verified.");
        }
    }

    public Set getSupportedExtensions() {
        if (this.supportedExts == null) {
            this.supportedExts = new HashSet();
            this.supportedExts.add(PKIXExtensions.KeyUsage_Id.toString());
            this.supportedExts.add(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            this.supportedExts.add(PKIXExtensions.SubjectAlternativeName_Id.toString());
            this.supportedExts = Collections.unmodifiableSet(this.supportedExts);
        }
        return this.supportedExts;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        --this.remainingCerts;
        if (this.remainingCerts == 0) {
            if (this.targetConstraints != null && !this.targetConstraints.match(x509Certificate)) {
                throw new CertPathValidatorException("target certificate constraints check failed");
            }
        } else {
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
        if (collection != null && !collection.isEmpty()) {
            collection.remove(PKIXExtensions.KeyUsage_Id.toString());
            collection.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            collection.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
        }
    }
}

