/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ReverseBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    private Date date;
    private X509CertSelector targetCertSelector;
    Set initPolicies;

    boolean isPathCompleted(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal().equals(this.targetSubjectDN);
    }

    void removeFinalCertFromPath(LinkedList linkedList) {
        linkedList.removeLast();
    }

    private Collection getMatchingCACerts(ReverseState reverseState) throws CertificateException, CertStoreException, IOException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        CertPathHelper.setIssuer(x509CertSelector, reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        x509CertSelector.addPathToName(4, this.targetCertSelector.getSubjectAsBytes());
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(0);
        ArrayList arrayList = new ArrayList();
        ReverseBuilder.addMatchingCerts(x509CertSelector, this.buildParams.getCertStores(), arrayList);
        Collections.sort(arrayList, new PKIXCertComparator());
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingCACerts got " + arrayList.size() + " certs.");
        }
        return arrayList;
    }

    private Collection getMatchingEECerts(ReverseState reverseState) throws CertStoreException, CertificateException, IOException {
        X509CertSelector x509CertSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        CertPathHelper.setIssuer(x509CertSelector, reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(-2);
        HashSet hashSet = new HashSet();
        ReverseBuilder.addMatchingCerts(x509CertSelector, this.buildParams.getCertStores(), hashSet);
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingEECerts got " + hashSet.size() + " certs.");
        }
        return hashSet;
    }

    Collection getMatchingCerts(State state) throws CertStoreException, CertificateException, IOException {
        ReverseState reverseState = (ReverseState)state;
        if (this.debug != null) {
            this.debug.println("In ReverseBuilder.getMatchingCerts.");
        }
        Collection collection = this.getMatchingEECerts(reverseState);
        collection.addAll(this.getMatchingCACerts(reverseState));
        return collection;
    }

    void addCertToPath(X509Certificate x509Certificate, LinkedList linkedList) {
        linkedList.addLast(x509Certificate);
    }

    ReverseBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal) {
        super(pKIXBuilderParameters, x500Principal);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.targetCertSelector = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
        Set set = pKIXBuilderParameters.getInitialPolicies();
        this.initPolicies = new HashSet();
        if (set.isEmpty()) {
            this.initPolicies.add("2.5.29.32.0");
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.initPolicies.add(iterator.next());
            }
        }
    }

    void verifyCert(X509Certificate x509Certificate, State state, List list) throws GeneralSecurityException {
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        ReverseState reverseState;
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        if ((reverseState = (ReverseState)state).isInitial()) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(0, iterator.next());
            }
            object3 = arrayList.iterator();
            boolean bl3 = false;
            while (object3.hasNext()) {
                object2 = (X509Certificate)object3.next();
                object = X509CertImpl.toImpl((X509Certificate)object2);
                PolicyMappingsExtension policyMappingsExtension = ((X509CertImpl)object).getPolicyMappingsExtension();
                if (policyMappingsExtension != null) {
                    bl3 = true;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + bl3);
                }
                if (!x509Certificate.equals(object2) || !this.buildParams.isPolicyMappingInhibited() && bl3) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        boolean bl4 = x509Certificate.getSubjectX500Principal().equals(this.targetSubjectDN);
        boolean bl5 = bl2 = x509Certificate.getBasicConstraints() != -1;
        if (!bl4) {
            if (!bl2) {
                throw new CertPathValidatorException("cert is NOT a CA cert");
            }
            if (reverseState.remainingCACerts <= 0 && !X509CertImpl.isSelfIssued(x509Certificate)) {
                throw new CertPathValidatorException("pathLenConstraint violated, path too long");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        } else if (!this.targetCertSelector.match(x509Certificate)) {
            throw new CertPathValidatorException("target certificate constraints check failed");
        }
        if (this.buildParams.isRevocationEnabled() && !(bl = reverseState.crlChecker.check(x509Certificate, reverseState.pubKey, true)) && !bl4) {
            throw new CertPathValidatorException("cert can't vouch for crl");
        }
        if ((bl4 || !X509CertImpl.isSelfIssued(x509Certificate)) && reverseState.nc != null) {
            try {
                if (!reverseState.nc.verify(x509Certificate)) {
                    throw new CertPathValidatorException("name constraints check failed");
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException(iOException);
            }
        }
        object3 = X509CertImpl.toImpl(x509Certificate);
        reverseState.rootNode = PolicyChecker.processPolicies(reverseState.certIndex, this.initPolicies, reverseState.explicitPolicy, reverseState.policyMapping, reverseState.inhibitAnyPolicy, this.buildParams.getPolicyQualifiersRejected(), reverseState.rootNode, (X509CertImpl)object3, bl4);
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        object2 = reverseState.userCheckers.iterator();
        while (object2.hasNext()) {
            object = (PKIXCertPathChecker)object2.next();
            ((PKIXCertPathChecker)object).check(x509Certificate, set);
        }
        if (!set.isEmpty()) {
            set.remove(PKIXExtensions.BasicConstraints_Id.toString());
            set.remove(PKIXExtensions.NameConstraints_Id.toString());
            set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            set.remove(PKIXExtensions.PolicyMappings_Id.toString());
            set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
            set.remove(PKIXExtensions.KeyUsage_Id.toString());
            set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            if (!set.isEmpty()) {
                throw new CertificateException("Unrecognized critical extension(s)");
            }
        }
        if (this.buildParams.getSigProvider() != null) {
            x509Certificate.verify(reverseState.pubKey, this.buildParams.getSigProvider());
        } else {
            x509Certificate.verify(reverseState.pubKey);
        }
    }

    class PKIXCertComparator
    implements Comparator {
        private Debug debug = Debug.getInstance("certpath");

        PKIXCertComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            X509Certificate x509Certificate = (X509Certificate)object;
            X509Certificate x509Certificate2 = (X509Certificate)object2;
            if (x509Certificate.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return -1;
            }
            if (x509Certificate2.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return 1;
            }
            try {
                X500Name x500Name = X500Name.asX500Name(ReverseBuilder.this.targetSubjectDN);
                n2 = Builder.targetDistance(null, x509Certificate, x500Name);
                n = Builder.targetDistance(null, x509Certificate2, x500Name);
            }
            catch (IOException iOException) {
                if (this.debug != null) {
                    this.debug.println("IOException in call to Builder.targetDistance");
                    iOException.printStackTrace();
                }
                throw new ClassCastException("Invalid target subject distinguished name");
            }
            if (n2 == n) {
                return 0;
            }
            if (n2 == -1) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 1;
        }
    }
}

