/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.util.Arrays;
import sun.security.util.MemoryCache;
import sun.security.util.NullCache;

public abstract class Cache {
    public abstract int size();

    protected Cache() {
    }

    public abstract void clear();

    public abstract void remove(Object var1);

    public static Cache newNullCache() {
        return NullCache.INSTANCE;
    }

    public static Cache newHardMemoryCache(int n) {
        return new MemoryCache(false, n);
    }

    public static Cache newSoftMemoryCache(int n) {
        return new MemoryCache(true, n);
    }

    public static Cache newHardMemoryCache(int n, int n2) {
        return new MemoryCache(false, n, n2);
    }

    public static Cache newSoftMemoryCache(int n, int n2) {
        return new MemoryCache(true, n, n2);
    }

    public abstract Object get(Object var1);

    public abstract void put(Object var1, Object var2);

    public static class EqualByteArray {
        private final byte[] b;
        private volatile int hash;

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                n = this.b.length + 1;
                for (int i = 0; i < this.b.length; ++i) {
                    n += (this.b[i] & 0xFF) * 37;
                }
                this.hash = n;
            }
            return n;
        }

        public EqualByteArray(byte[] byArray) {
            this.b = byArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof EqualByteArray)) {
                return false;
            }
            EqualByteArray equalByteArray = (EqualByteArray)object;
            return Arrays.equals(this.b, equalByteArray.b);
        }
    }
}

