/*NEO SDK V2.1.90 For DOS
  Copyleft Cker Home 2003-2006.

  Open Source Obey NEO_PL.TXT.
  http://neo.coderlife.net
  ckerhome@yahoo.com.cn

  ļ : nsound.h
  ժ    Ҫ : ͷļаNEO SDKйƵŵĺṹȫֱ
             Ŀǰָ֧ʽ:׼ļwav(PCM 8λ /˫)
  ǰ汾 : V0.67
       : 
   : 2006.01.18

  ȡ汾 : V0.66
  ԭ   : 
   : 2005.12.29
*/

#ifndef  __NSOUND_H__
#define  __NSOUND_H__

#ifndef NEO_sound_unused

#define PCM_HEAD_LONG  50
#define PLAY_DELAY     100


typedef struct WaveData
{
   FILE           *fp;
   long           pos; /*ǰWAVļŽ*/
   unsigned short sample_lenth; /*Ƶĳߴ*/
   unsigned short rate;
   unsigned short channels;
   unsigned char  time_constant;
   char           loop;

   char           *sample;
}SAMPLE;

struct HeaderType
{
   long           riff;       /*RIFFԴļͷ*/
   unsigned long  file_len;   /*ļ*/
   char           wave[4];    /*"WAVE"־*/
   char           fmt [4];    /*"fmt"־*/
   char           NI1 [4];    /*ֽ*/
   unsigned short format_type;/*ʽ(10HΪPCMʽ)*/
   unsigned short Channels;   /*Channels 1 = ; 2 = */
   long           frequency;  /*Ƶ*/
   long           trans_speed;/*Ƶݴ*/
   char           NI2 [2];    /*ֽ*/
   short          sample_bits;/*λ(8/16)*/
   char           data[4];    /*ݱǷ"data"*/
   unsigned long  wav_len;    /*ݵĳ*/
   char           NI3 [4];    /*ֽ*/
};

/*char g_last_wav[PATH_LENGTH] = {'\0'}; */

unsigned short g_base;        /*ַ*/
unsigned short g_port;
/*long sb_hw_dsp_ver = -1;*/

SAMPLE *g_sample;

void   write_dsp( unsigned char value );
short  ResetDSP ( unsigned short Test );
void   _sb_set_mixer(short index, char value);
short  install_sound(void);
short  play_sample_ex(SAMPLE *spl, short vol, short pan, short freq, short loop);
SAMPLE *load_wav(char *filename);
char   play_back  (SAMPLE *wave);
void   stop_sample(SAMPLE *spl);
void   destroy_sample(SAMPLE *spl);
void   remove_sound(void);

/*Ϊǰ汾*/
#define reset_dsp() ResetDSP(g_port)
#define play_sample(mode) play_sample_ex(SAMPLE *g_sample, 255, 255, 0, mode)
#define clear_digi_buffer()
#define set_port(port)
#define set_irq(irq)
#define set_dma(dma)

short install_sound(void)
{
   /*if (digi_card)
   {*/
      if ( ResetDSP (0x220) )
      {
         /*ַΪ220h*/
         g_port = 0x220;
      }
      else if (ResetDSP (0x230))
      {
         /*ַΪ230h*/
         g_port = 0x230;
      }
      else if (ResetDSP (0x240))
      {
         /*ַΪ240h*/
         g_port = 0x240;
      }
      else
      {
         /*ַʧ*/
         g_port = -1;
         return 0;
      }
   /*}
   if (midi_card)
   {}*/

   g_routines |= 64;
   return 1;
}


/****************************************************************************
 һַǷڣλ                             *
****************************************************************************/
short ResetDSP(unsigned short Test)
{
   /*DSP*/
   outportb (Test + 0x6, 1);
   delay(50);
   outportb (Test + 0x6, 0);
   delay(50);
   /*óɹ*/
   if (( (inportb(Test + 0xE) & 0x80) == 0x80) && (inportb(Test + 0xA) == 0xAA))
   {
      /*DSPҵ*/
      g_base = Test;
      return (1);
   }
   else
   {  /*ҲDSP*/
      return (0);
   }
}


/****************************************************************************
** һֽڵDSP(źŴоƬDigital Signal Processor)     **
****************************************************************************/
void write_dsp(unsigned char value)
{
   /*ȴDSPһֽ*/
   while ((inportb(g_base + 0xC) & 0x80) == 0x80);
   /*ֽ*/
   outportb (g_base + 0xC, value);
}


/****************************************************************************
** ڴеĲƵ                                                  **
****************************************************************************/
char play_back (SAMPLE *wave)
{
   long         LinearAddress;
   unsigned short page, offset;

   if ((!wave) || (!wave->sample))
   {
      printf("no sample!");
      return 0;
   }
   /**/
   write_dsp( 0xD1 );

   write_dsp( 0x40 );                    /*DSP40h òƵ*/
   write_dsp( wave -> time_constant );            /*Write time constant*/
   /*ƵָתԵַ*/
   LinearAddress = FP_SEG ( wave -> sample );
   LinearAddress = ( LinearAddress << 4 ) + FP_OFF ( wave->sample );
   page   = LinearAddress >> 16;      /*ҳ*/
   offset = LinearAddress & 0xFFFF;   /*ҳƫ*/
   /*ע ֻܹDMAĵһͨ*/
   outportb (0x0A, 5);                /*Mask DMAͨһ*/
   outportb (0x0C, 0);                /*DMAڲת־*/
   outportb (0x0B, 0x49);             /*óɻأģʽ*/
   /*
    ģʽ漸:
    0x49 =  01 00 10 01
                  |  |  |  |
                  |  |  |  +- DMAͨ 01
                  |  |  +----  (ڴ浽DSP)
                  |  +------- һڷʽ
                  +---------- 鷽ʽ
   */
   outportb ( 0x02, offset & 0x100);  /*ƫдDMA*/
   outportb ( 0x02, offset >> 8);
   outportb ( 0x83, page);             /*ҳдDMA*/
   outportb ( 0x03, wave->sample_lenth & 0x100);
   outportb ( 0x03, wave->sample_lenth >> 8);
   outportb ( 0x0A, 1 );               /*DMAͨһ*/
   write_dsp( 0x14 );                  /*DSP14h һڻط*/
   write_dsp( wave -> sample_lenth & 0xFF );
   write_dsp( wave -> sample_lenth >> 8);
   return 1;
}


/****************************************************************************
** Ƶļڴ                                                      **
** ܲ׼PCMļͷ                                         **
**                                                     **
****************************************************************************/
SAMPLE *load_wav(char *filename)
{
   struct HeaderType t_header;
   FILE   *wav_file;
   SAMPLE *voice;

   /*򲻿ļ...*/
   wav_file = fopen(filename, "rb");
   if (wav_file == NULL)
   {
         #ifndef NEO_sys_report_error_unused
         Errinfo_t error = {"load_wav", NO_FILE, 1};
         throw_error(error);
         #endif
      return (NULL);
   }

   voice = (SAMPLE *)malloc(sizeof(SAMPLE));
   if ( voice == NULL)
   {
      #ifndef NEO_sys_report_error_unused
      Errinfo_t error = {"load_wav", NO_MEMORY, 1};
      throw_error(error);
      #endif
      return NULL;
   }

   /*if ((strnicmp(g_last_wav, filename, strlen(bmpfile) ) != 0)
   {*/
      /*ȡļͷ*/
      fread ( &t_header, sizeof(t_header), 1, wav_file );
      /*RIFFͷ*/
      if ( t_header.riff != 0x46464952L)
      {
         #ifndef NEO_sys_report_error_unused
         Errinfo_t error = {"load_wav", ERR_FILE_TYPE, 1};
         throw_error(error);
         #endif
         return ( NULL );
      }
      /*ͨ*/
      if ( t_header.Channels != 1 )
      {
         #ifndef NEO_sys_report_error_unused
         Errinfo_t error = {"load_wav", "Not a MONO wave file!", 1};
         throw_error(error);
         #endif
         return ( NULL );
      }
      /*λ*/
      if ( t_header.sample_bits != 8 )
      {
         #ifndef NEO_sys_report_error_unused
         Errinfo_t error = {"load_wav", "Not an 8 bits wav file!", 1};
         throw_error(error);
         #endif
         return ( NULL );
      }
      /*strcpy(g_last_wav,filename);
   }*/

   voice->sample_lenth = (unsigned short)(t_header.file_len - PCM_HEAD_LONG);
   voice->time_constant= 256 - (1000000L / ( (voice->rate=t_header.frequency) * (voice->channels=t_header.Channels) ));

   if ( t_header.file_len - PCM_HEAD_LONG >= 0xffff )
   {
      voice->sample_lenth = 0xfffe;
   }
   if (voice->sample_lenth == 0) voice->sample_lenth = 1;
   voice->sample = (char *) malloc ( voice->sample_lenth + 1);/*ڴ*/
   if ( voice->sample == NULL)
   {
      #ifndef NEO_sys_report_error_unused
      Errinfo_t error = {"load_wav", NO_MEMORY, 1};
      throw_error(error);
      #endif
      fclose ( wav_file ); /*رļ*/
      return NULL;
   }
   voice->pos = voice->sample_lenth;
   /*fseek(wav_file, 57L, SEEK_SET);*/
   /*ȡ*/
   fread  ( voice->sample, voice->sample_lenth + 1, 1, wav_file );
   fclose ( wav_file ); /*رļ*/
   g_sample = voice;
   return voice;
}


short play_sample_ex(SAMPLE *spl, short vol, short pan, short freq, short loop)
{

   vol += 0;
   pan += 0;
   freq+= 0;
   spl->loop |= loop;

   if (spl)
   {
      /*ʼط*/
      play_back(spl);
      delay(PLAY_DELAY);
      /*ֹͣ DMA */
      write_dsp(0xD0);
      return 1;
   }
   return 0;
}


void stop_sample(SAMPLE *spl)
{ spl+=0;
/*   SAMPLE stop;
   char   sam[10];

   stop.sample = sam;
   stop.sample_lenth = 9;
   stop.time_constant= 9;
   play_back(&stop);*/
}


void destroy_sample(SAMPLE *spl)
{
   if (spl)
   {
      free(spl->sample);
      spl->sample = NULL;
      free(spl);
      spl = NULL;
   }
}


void remove_sound(void)
{
   /*ر*/
   write_dsp(0xD3);
   /*DSP*/
   reset_dsp();
   g_routines &= 191;
}

#endif


#endif
