/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.annotations;

import com.oracle.outsidein.ColorInfo;
import com.oracle.outsidein.annotations.Annotation;
import java.util.EnumSet;
import net.bitform.oilink.OILinkMessages;

public class HighlightAreaAnnotation
extends Annotation {
    private BorderStyleValue m_BorderStyle = BorderStyleValue.NONE;
    private AnnoBorder m_TopBorder = null;
    private AnnoBorder m_LeftBorder = null;
    private AnnoBorder m_RightBorder = null;
    AnnoBorder m_BottomBorder = null;
    private ColorInfo m_fillColor;

    public void setBorder(EnumSet<BorderSideValue> enumSet, AnnoBorder annoBorder) {
        if (enumSet.containsAll(EnumSet.allOf(BorderSideValue.class))) {
            this.m_LeftBorder = this.m_BottomBorder = annoBorder;
            this.m_RightBorder = this.m_BottomBorder;
            this.m_TopBorder = this.m_BottomBorder;
        } else {
            if (enumSet.contains((Object)BorderSideValue.LEFT)) {
                this.m_LeftBorder = annoBorder;
            }
            if (enumSet.contains((Object)BorderSideValue.RIGHT)) {
                this.m_RightBorder = annoBorder;
            }
            if (enumSet.contains((Object)BorderSideValue.TOP)) {
                this.m_TopBorder = annoBorder;
            }
            if (enumSet.contains((Object)BorderSideValue.BOTTOM)) {
                this.m_BottomBorder = annoBorder;
            }
        }
    }

    public BorderStyleValue getBorderStyle() {
        return this.m_BorderStyle;
    }

    public void setBorderStyle(BorderStyleValue borderStyleValue) {
        this.m_BorderStyle = borderStyleValue;
    }

    public AnnoBorder getTopBorder() {
        return this.m_TopBorder;
    }

    public void setTopBorder(AnnoBorder annoBorder) {
        this.m_TopBorder = annoBorder;
    }

    public AnnoBorder getLeftBorder() {
        return this.m_LeftBorder;
    }

    public void setLeftBorder(AnnoBorder annoBorder) {
        this.m_LeftBorder = annoBorder;
    }

    public AnnoBorder getRightBorder() {
        return this.m_RightBorder;
    }

    public void setRightBorder(AnnoBorder annoBorder) {
        this.m_RightBorder = annoBorder;
    }

    public AnnoBorder getBottomBorder() {
        return this.m_BottomBorder;
    }

    public void setBottomBorder(AnnoBorder annoBorder) {
        this.m_BottomBorder = annoBorder;
    }

    protected ColorInfo getFillColor() {
        return this.m_fillColor;
    }

    protected void setFillColor(ColorInfo colorInfo) {
        this.m_fillColor = colorInfo;
    }

    public HighlightAreaAnnotation(long l, long l2, long l3, long l4, long l5, long l6, Annotation.UnitTypeValue unitTypeValue, float f, ColorInfo colorInfo, AnnoBorder annoBorder, BorderStyleValue borderStyleValue) {
        super(l, l2, l3, l4, l5, l6, unitTypeValue, f);
        this.m_fillColor = colorInfo;
        this.m_BorderStyle = borderStyleValue;
        this.m_LeftBorder = this.m_BottomBorder = annoBorder;
        this.m_RightBorder = this.m_BottomBorder;
        this.m_TopBorder = this.m_BottomBorder;
    }

    public OILinkMessages.HiliteArea getOILinkHiliteArea() {
        OILinkMessages.Color.Builder builder = null;
        AnnoBorder annoBorder = null;
        OILinkMessages.HiliteArea.Builder builder2 = OILinkMessages.HiliteArea.newBuilder().setSection(this.getSectionIndex()).setTop(this.getTop()).setLeft(this.getLeft()).setWidth(this.getWidth()).setHeight(this.getHeight());
        if (Annotation.UnitTypeValue.TWIPS == this.getUnits()) {
            builder2.setUnits(OILinkMessages.HiliteUnits.TWIPS);
        } else {
            builder2.setUnits(OILinkMessages.HiliteUnits.PIXELS);
        }
        builder2.setUserData(this.getUserId());
        if (null != this.getFillColor()) {
            builder = OILinkMessages.Color.newBuilder().setBlue(this.getFillColor().getBlue()).setGreen(this.getFillColor().getGreen()).setRed(this.getFillColor().getRed());
            builder2.setFillColor(builder.build());
        }
        builder2.setFillOpacity(this.getOpacity());
        annoBorder = this.getTopBorder();
        if (null != annoBorder) {
            if (null != annoBorder.m_color) {
                builder = OILinkMessages.Color.newBuilder().setBlue(annoBorder.m_color.getBlue()).setGreen(annoBorder.m_color.getGreen()).setRed(annoBorder.m_color.getRed());
                builder2.setBorderTopColor(builder.build());
            }
            builder2.setBorderTopThickness(annoBorder.m_thickness);
        }
        if (null != (annoBorder = this.getLeftBorder())) {
            if (null != annoBorder.m_color) {
                builder = OILinkMessages.Color.newBuilder().setBlue(annoBorder.m_color.getBlue()).setGreen(annoBorder.m_color.getGreen()).setRed(annoBorder.m_color.getRed());
                builder2.setBorderLeftColor(builder.build());
            }
            builder2.setBorderLeftThickness(annoBorder.m_thickness);
        }
        if (null != (annoBorder = this.getBottomBorder())) {
            if (null != annoBorder.m_color) {
                builder = OILinkMessages.Color.newBuilder().setBlue(annoBorder.m_color.getBlue()).setGreen(annoBorder.m_color.getGreen()).setRed(annoBorder.m_color.getRed());
                builder2.setBorderBottomColor(builder.build());
            }
            builder2.setBorderBottomThickness(annoBorder.m_thickness);
        }
        if (null != (annoBorder = this.getRightBorder())) {
            if (null != annoBorder.m_color) {
                builder = OILinkMessages.Color.newBuilder().setBlue(annoBorder.m_color.getBlue()).setGreen(annoBorder.m_color.getGreen()).setRed(annoBorder.m_color.getRed());
                builder2.setBorderRightColor(builder.build());
            }
            builder2.setBorderRightThickness(annoBorder.m_thickness);
        }
        if (BorderStyleValue.NONE == this.getBorderStyle()) {
            builder2.setBorderStyle(OILinkMessages.HiliteArea.HiliteAreaBorderStyle.NONE);
        } else if (BorderStyleValue.DOTTED == this.getBorderStyle()) {
            builder2.setBorderStyle(OILinkMessages.HiliteArea.HiliteAreaBorderStyle.DOT);
        } else if (BorderStyleValue.DASHED == this.getBorderStyle()) {
            builder2.setBorderStyle(OILinkMessages.HiliteArea.HiliteAreaBorderStyle.DASH);
        } else {
            builder2.setBorderStyle(OILinkMessages.HiliteArea.HiliteAreaBorderStyle.SOLID);
        }
        return builder2.build();
    }

    public static enum BorderStyleValue {
        NONE(0L),
        DOTTED(2L),
        DASHED(3L),
        SOLID(1L);

        public final long value;

        private BorderStyleValue(long l) {
            this.value = l;
        }
    }

    public static class AnnoBorder {
        ColorInfo m_color;
        long m_thickness;

        public AnnoBorder(ColorInfo colorInfo, long l) {
            this.m_color = colorInfo;
            this.m_thickness = l;
        }
    }

    public static enum BorderSideValue {
        LEFT(1L),
        RIGHT(2L),
        TOP(4L),
        BOTTOM(8L);

        final long value;

        private BorderSideValue(long l) {
            this.value = l;
        }
    }
}

