/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import java.io.File;

public class OutsideInConfig {
    private File m_installLocationDirectory = null;
    private boolean m_bHasProcessRestartThreshold = false;
    private RestartThreshold m_ProcessRestartThreshold = RestartThreshold.MEDIUM;

    public void setLocation(File file) {
        this.m_installLocationDirectory = file;
    }

    public File getLocation() {
        return this.m_installLocationDirectory;
    }

    public void setProcessRestartThreshold(RestartThreshold restartThreshold) {
        this.m_ProcessRestartThreshold = restartThreshold;
        this.m_bHasProcessRestartThreshold = true;
    }

    public RestartThreshold getProcessRestartThreshold() {
        return this.m_ProcessRestartThreshold;
    }

    public OutsideInConfig() {
    }

    public OutsideInConfig(File file, RestartThreshold restartThreshold) {
        this.m_ProcessRestartThreshold = restartThreshold;
        this.m_bHasProcessRestartThreshold = true;
        this.m_installLocationDirectory = file;
    }

    public int getOILinkProcessResetCount() {
        int n = 200;
        if (this.m_bHasProcessRestartThreshold) {
            switch (this.m_ProcessRestartThreshold) {
                case LOW: {
                    n = 50;
                    break;
                }
                case MEDIUM: {
                    n = 200;
                    break;
                }
                case HIGH: {
                    n = 400;
                }
            }
        }
        return n;
    }

    public static enum RestartThreshold {
        LOW(0L),
        MEDIUM(1L),
        HIGH(2L);

        final long value;

        private RestartThreshold(long l) {
            this.value = l;
        }
    }
}

