/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MailHeaders {
    static final long NONSTANDARD_HEADER_ID_BASE = 0L;
    static final long NONSTANDARD_HEADER_ID_TOP = 99L;
    static final long MAX_NONSTANDARD_HEADERS = 99L;
    private BaselineValue m_Baseline;
    private Map<MailTypeValue, List<MailHeaderValue>> m_visibleStandardHeadersList = null;
    private Map<MailTypeValue, List<MailHeaderValue>> m_hiddenStandardHeadersList = null;
    private Map<MailTypeValue, Map<String, String>> m_visibleCustomHeadersList = null;
    private Map<MailTypeValue, List<String>> m_hiddenCustomHeadersList = null;

    public BaselineValue getBaseline() {
        return this.m_Baseline;
    }

    public void setBaseline(BaselineValue baselineValue) {
        this.m_Baseline = baselineValue;
    }

    Map<MailTypeValue, List<MailHeaderValue>> getVisibleStandardHeadersList() {
        return this.m_visibleStandardHeadersList;
    }

    Map<MailTypeValue, List<MailHeaderValue>> getHiddenStandardHeadersList() {
        return this.m_hiddenStandardHeadersList;
    }

    Map<MailTypeValue, Map<String, String>> getVisibleCustomHeadersList() {
        return this.m_visibleCustomHeadersList;
    }

    Map<MailTypeValue, List<String>> getHiddenCustomHeadersList() {
        return this.m_hiddenCustomHeadersList;
    }

    public MailHeaders() {
        this.m_Baseline = BaselineValue.STANDARD;
        this.m_hiddenStandardHeadersList = null;
        this.m_visibleStandardHeadersList = null;
    }

    public MailHeaders(BaselineValue baselineValue) {
        this.m_Baseline = baselineValue;
        this.m_hiddenStandardHeadersList = null;
        this.m_visibleStandardHeadersList = null;
    }

    MailHeaders(MailHeaders mailHeaders) {
        Cloneable cloneable;
        this.m_Baseline = mailHeaders.m_Baseline;
        if (mailHeaders.m_hiddenStandardHeadersList != null) {
            this.m_hiddenStandardHeadersList = new HashMap<MailTypeValue, List<MailHeaderValue>>();
            for (MailTypeValue mailTypeValue : mailHeaders.m_hiddenStandardHeadersList.keySet()) {
                cloneable = new LinkedList();
                for (MailHeaderValue object : mailHeaders.m_hiddenStandardHeadersList.get((Object)mailTypeValue)) {
                    cloneable.add(object);
                }
                this.m_hiddenStandardHeadersList.put(mailTypeValue, (List<MailHeaderValue>)((Object)cloneable));
            }
        }
        if (mailHeaders.m_visibleStandardHeadersList != null) {
            this.m_visibleStandardHeadersList = new HashMap<MailTypeValue, List<MailHeaderValue>>();
            for (MailTypeValue mailTypeValue : mailHeaders.m_visibleStandardHeadersList.keySet()) {
                cloneable = new LinkedList();
                for (MailHeaderValue mailHeaderValue : mailHeaders.m_visibleStandardHeadersList.get((Object)mailTypeValue)) {
                    cloneable.add(mailHeaderValue);
                }
                this.m_visibleStandardHeadersList.put(mailTypeValue, (List<MailHeaderValue>)((Object)cloneable));
            }
        }
        if (mailHeaders.m_visibleCustomHeadersList != null) {
            this.m_visibleCustomHeadersList = new HashMap<MailTypeValue, Map<String, String>>();
            for (MailTypeValue mailTypeValue : mailHeaders.m_visibleCustomHeadersList.keySet()) {
                cloneable = new HashMap<String, String>(mailHeaders.m_visibleCustomHeadersList.get((Object)mailTypeValue));
                this.m_visibleCustomHeadersList.put(mailTypeValue, (Map<String, String>)((Object)cloneable));
            }
        }
        if (mailHeaders.m_hiddenStandardHeadersList != null) {
            this.m_hiddenCustomHeadersList = new HashMap<MailTypeValue, List<String>>();
            for (MailTypeValue mailTypeValue : mailHeaders.m_hiddenCustomHeadersList.keySet()) {
                cloneable = new LinkedList();
                for (String string : mailHeaders.m_hiddenCustomHeadersList.get((Object)mailTypeValue)) {
                    cloneable.add(string);
                }
                this.m_hiddenCustomHeadersList.put(mailTypeValue, (List<String>)((Object)cloneable));
            }
        }
    }

    public MailHeaders includeHeader(MailTypeValue mailTypeValue, MailHeaderValue mailHeaderValue) {
        if (this.m_visibleStandardHeadersList == null) {
            this.m_visibleStandardHeadersList = new HashMap<MailTypeValue, List<MailHeaderValue>>();
        }
        List<Object> list = null;
        if (this.m_visibleStandardHeadersList.containsKey((Object)mailTypeValue)) {
            list = this.m_visibleStandardHeadersList.get((Object)mailTypeValue);
        } else {
            list = new LinkedList();
            this.m_visibleStandardHeadersList.put(mailTypeValue, list);
        }
        list.add((Object)mailHeaderValue);
        return this;
    }

    public MailHeaders excludeHeader(MailTypeValue mailTypeValue, MailHeaderValue mailHeaderValue) {
        if (this.m_hiddenStandardHeadersList == null) {
            this.m_hiddenStandardHeadersList = new HashMap<MailTypeValue, List<MailHeaderValue>>();
        }
        List<Object> list = null;
        if (this.m_hiddenStandardHeadersList.containsKey((Object)mailTypeValue)) {
            list = this.m_hiddenStandardHeadersList.get((Object)mailTypeValue);
        } else {
            list = new LinkedList();
            this.m_hiddenStandardHeadersList.put(mailTypeValue, list);
        }
        list.add((Object)mailHeaderValue);
        return this;
    }

    public MailHeaders includeHeader(MailTypeValue mailTypeValue, String string, String string2) {
        if (this.m_visibleCustomHeadersList == null) {
            this.m_visibleCustomHeadersList = new HashMap<MailTypeValue, Map<String, String>>();
        }
        Map<Object, Object> map = null;
        if (this.m_visibleCustomHeadersList.containsKey((Object)mailTypeValue)) {
            map = this.m_visibleCustomHeadersList.get((Object)mailTypeValue);
        } else {
            map = new HashMap();
            this.m_visibleCustomHeadersList.put(mailTypeValue, map);
        }
        if (map.containsKey(string)) {
            map.remove(string);
        }
        map.put(string, string2);
        return this;
    }

    public MailHeaders excludeHeader(MailTypeValue mailTypeValue, String string) {
        if (this.m_hiddenCustomHeadersList == null) {
            this.m_hiddenCustomHeadersList = new HashMap<MailTypeValue, List<String>>();
        }
        List<Object> list = null;
        if (this.m_hiddenCustomHeadersList.containsKey((Object)mailTypeValue)) {
            list = this.m_hiddenCustomHeadersList.get((Object)mailTypeValue);
        } else {
            list = new LinkedList();
            this.m_hiddenCustomHeadersList.put(mailTypeValue, list);
        }
        list.add(string);
        return this;
    }

    public void setVisibleHeaders(Map<MailTypeValue, Map<String, String>> map) {
        this.m_visibleCustomHeadersList = map;
    }

    public void setHiddenHeaders(Map<MailTypeValue, List<String>> map) {
        this.m_hiddenCustomHeadersList = map;
    }

    public static enum MailHeaderValue {
        TO(79466L),
        CC(79467L),
        BCC(79468L),
        SUBJECT(79469L),
        MSGFLAG(79470L),
        FLAGSTS(79471L),
        EXPIRES(79472L),
        CATEGORIES(79473L),
        IMPORTANCE(79474L),
        SENSITIVITY(79475L),
        LOCATION(79476L),
        FULLNAME(79477L),
        JOBTITLE(79478L),
        COMPANY(79479L),
        EMAIL(79480L),
        WEBPAGE(79481L),
        WORKPHONE(79482L),
        HOMEPHONE(79483L),
        FROM(79484L),
        ATTACHMENT(79485L),
        RTFBODY(79486L),
        RECEIVED(79487L),
        SIZE(79488L),
        LASTMODIFIED(79489L),
        NEWSGROUPS(79490L),
        SUBMITTIME(79491L),
        CCME(79492L),
        ALTERNATE_RECIPIENT_ALLOWED(79493L),
        CLIENT_SUBMIT_TIME(79494L),
        CREATION_TIME(79495L),
        CONVERSATION_INDEX(79496L),
        CONVERSATION_TOPIC(79497L),
        MESSAGE_SUBMISSION_ID(79498L),
        MESSAGE_CLASS(79499L),
        ORIGINATOR_DELIVERY_REPORT_REQUESTED(79500L),
        READ_RECEIPT_REQUESTED(79501L),
        RCVD_REPRESENTING_ADDRTYPE(79502L),
        RCVD_REPRESENTING_EMAIL_ADDRESS(79503L),
        RCVD_REPRESENTING_ENTRYID(79504L),
        RCVD_REPRESENTING_NAME(79505L),
        RCVD_REPRESENTING_SEARCH_KEY(79506L),
        RECEIVED_BY_ADDRTYPE(79507L),
        RECEIVED_BY_EMAIL_ADDRESS(79508L),
        RECEIVED_BY_ENTRYID(79509L),
        RECEIVED_BY_NAME(79510L),
        RECEIVED_BY_SEARCH_KEY(79511L),
        RTF_IN_SYNC(79512L),
        RTF_SYNC_BODY_COUNT(79513L),
        RTF_SYNC_BODY_CRC(79514L),
        RTF_SYNC_BODY_TAG(79515L),
        RTF_SYNC_PREFIX_COUNT(79516L),
        RTF_SYNC_TRAILING_COUNT(79517L),
        SEARCH_KEY(79518L),
        SENDER_ADDRTYPE(79519L),
        SENDER_EMAIL_ADDRESS(79520L),
        SENDER_ENTRYID(79521L),
        SENDER_NAME(79522L),
        SENDER_SEARCH_KEY(79523L),
        SENT_REPRESENTING_ADDRTYPE(79524L),
        SENT_REPRESENTING_EMAIL_ADDRESS(79525L),
        SENT_REPRESENTING_ENTRYID(79526L),
        SENT_REPRESENTING_SEARCH_KEY(79527L),
        TRANSPORT_MESSAGE_HEADERS(79528L),
        PRIORITY(79529L),
        AUTO_FORWARDED(79530L),
        DEFERRED_DELIVERY_TIME(79531L),
        EXPIRY_TIME(79532L),
        LATEST_DELIVERY_TIME(79533L),
        RECIPIENT_REASSIGNMENT_PROHIBITED(79534L),
        REPLY_TIME(79535L),
        REPORT_TAG(79536L),
        RESPONSE_REQUESTED(79537L),
        REPLY_REQUESTED(79538L),
        DELETE_AFTER_SUBMIT(79539L),
        MESSAGE_LOCALE_ID(79540L),
        CREATOR_NAME(79541L),
        CREATOR_ENTRYID(79542L),
        LAST_MODIFIER_NAME(79543L),
        LAST_MODIFIER_ENTRYID(79544L),
        INTERNET_ARTICLE_NUMBER(79545L),
        NT_SECURITY_DESCRIPTOR(79546L),
        TRUST_SENDER(79547L),
        INTERNET_MESSAGE_ID(79548L),
        ATTR_HIDDEN(79549L),
        ATTR_SYSTEM(79550L),
        ATTR_READONLY(79551L),
        INTERNET_CPID(79552L),
        MESSAGE_CODEPAGE(79553L),
        SENDER_FLAGS(79554L),
        SENT_REPRESENTING_FLAGS(79555L),
        RCVD_BY_FLAGS(79556L),
        RCVD_REPRESENTING_FLAGS(79557L),
        INET_MAIL_OVERRIDE_FORMAT(79558L),
        MSG_EDITOR_FORMAT(79559L),
        PROFILE_CONNECT_FLAGS(79560L),
        SENT_REPRESENTING_NAME(79561L),
        ENTRYID(79562L),
        NORMALIZED_SUBJECT(79563L),
        ATTENDEES(79564L),
        REQATTENDEE(79565L),
        OPTATTENDEE(79566L),
        FILEAS(79567L),
        DISPLAYAS(79568L),
        TITLE(79569L),
        SUFFIX(79570L),
        NICKNAME(79571L),
        PROFESSION(79572L),
        DEPARTMENT(79573L),
        OFFICE(79574L),
        ANNIVERSARY(79575L),
        BIRTHDATE(79576L),
        ASSISTANTSNAME(79577L),
        SPOUSESNAME(79578L),
        MANAGERSNAME(79579L),
        BUSINESSADDRESS(79580L),
        BUSINESSPHONE(79581L),
        HOMEADDRESS(79582L),
        OTHERADDRESS(79583L),
        MOBILEPHONE(79584L),
        BUSINESSFAX(79585L),
        IMADDRESS(79586L),
        INTERNETFREEBUSYADDR(79587L),
        REMINDERTOPIC(79588L),
        CONTACTS(79589L),
        CALLBACKPHONE(79590L),
        FIRST(79591L),
        FAMILY(79592L),
        TELENUMBER(79593L),
        BUSINESSPHONE2(79594L),
        RADIOPHONE(79595L),
        CARPHONE(79596L),
        OTHERPHONE(79597L),
        PAGERPHONE(79598L),
        OTHERFAX(79599L),
        HOMEFAX(79600L),
        TELEXPHONE(79601L),
        ISDN(79602L),
        ASSISTANTPHONE(79603L),
        HOMEPHONE2(79604L),
        MIDDLE(79605L),
        TTYTTDPHONE(79606L),
        GENDER(79607L),
        PERSONALHOMEPAGE(79608L),
        COMPANYPHONE(79609L),
        HOMECITY(79610L),
        HOMECOUNTRY(79611L),
        POSTALCODE(79612L),
        HOMESTATE(79613L),
        HOMESTREET(79614L),
        HOMEPOBOX(79615L),
        OTHERCITY(79616L),
        OTHERCOUNTRY(79617L),
        OTHERPOSTALCODE(79618L),
        OTHERSTATE(79619L),
        OTHERSTREET(79620L),
        OTHERPOBOX(79621L),
        BUSINESSSTREET(79622L),
        BUSINESSCITY(79623L),
        BUSINESSSTATE(79624L),
        BUSINESSPOSTALCODE(79625L),
        BUSINESSCOUNTRY(79626L),
        BUSINESSPOBOX(79627L),
        DISPLAYAS2(79628L),
        EMAIL2(79629L),
        DISPLAYAS3(79630L),
        EMAIL3(79631L),
        DTSTART(79632L),
        DTEND(79633L),
        START(79634L),
        DURATION(79635L),
        ACCUREATTYPE1(79636L),
        ENTRY_TYPE(79637L),
        STATUS(79638L),
        PERCENT_COMPLETE(79639L),
        START_DATE(79640L),
        DUE_DATE(79641L),
        COMPLETED(79642L),
        ACTUALWORK(79643L),
        TOTAL_WORK(79644L),
        OWNER(79645L),
        BILLING(79646L),
        MILEAGE(79647L),
        PROOF_OF_DELIVERY_REQUESTED(79648L),
        PROOF_OF_SUBMISSION_REQUESTED(79649L),
        IN_REPLY_TO_ID(79650L),
        TASK_COMPLETE(79651L),
        APPOINTMENT_DURATION(79652L),
        UNKNOWN(79656L),
        RECURRENCE_TYPE(79653L),
        RECURRENCE_RANGE(79654L),
        ORGANIZER(79655L);

        final long value;

        private MailHeaderValue(long l) {
            this.value = l;
        }
    }

    public static enum BaselineValue {
        ALL(0L),
        STANDARD(1L),
        NONE(2L);

        final long value;

        private BaselineValue(long l) {
            this.value = l;
        }
    }

    public static enum MailTypeValue {
        EMAIL(1L),
        JOURNAL(2L),
        CONTACT(4L),
        NOTE(8L),
        APPOINTMENT(16L),
        TASK(32L),
        POST(64L),
        DISTROLIST(128L);

        final long value;

        private MailTypeValue(long l) {
            this.value = l;
        }
    }
}

