<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    cdata-section-elements="script" />

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="css/stylesheet.css" rel="stylesheet" type="text/css"/>
<script type="text/javascript" language="javascript">
<xsl:comment>
<![CDATA[
	function autoResize(id){
    var newheight;

    if (!window.opera && !document.mimeType && document.all && document.getElementById){
        newheight=document.getElementById(id).contentWindow.document .body.offsetHeight;
    }else if(document.getElementById){
        newheight=document.getElementById(id).contentWindow.document .body.scrollHeight;
    }

    document.getElementById(id).height= (newheight + 16) + "px";
	}
]]>
</xsl:comment>
</script>
<script type="text/javascript" language="javascript">
<xsl:comment>
<![CDATA[
	function equalize() {
	
 		var left=document.getElementById('thumbframe');
 		var right=document.getElementById('framedivright');

 		left.style.height=right.offsetHeight+"px";
	}
	onload=equalize;
	onresize=equalize;
]]>
</xsl:comment>
</script>
</head>
<body>
<div id="wrapper">
	<xsl:if test="/Doc/IncludeHeader = 1">
  <xsl:if test="/Doc/Header/UseImage = 1">
  	<div id="logohead"><img src="{/Doc/Header/ImagePath}"/></div>
  </xsl:if>
    
  <xsl:if test="/Doc/Header/UseInfo = 1">
  	<div id="pagehead">
  		<xsl:if test="/Doc/Header/Text[string(.)] or /Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
    		<div class="left">
    			<xsl:if test="/Doc/Header/Text[string(.)]">
    				<xsl:value-of select="Doc/Header/Text"/>
    				<xsl:if test="/Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Header/Author[string(.)]">
    				<xsl:value-of select="Doc/Header/Author"/>
    				<xsl:if test="/Doc/Header/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Header/Date[string(.)]">
    				<xsl:value-of select="Doc/Header/Date"/>
    			</xsl:if>
    		</div>
    	</xsl:if>
    	<xsl:if test="/Doc/Header/Email[string(.)]">
    		<div class="right"><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></div>
    	</xsl:if>
    	<div class="clearer">&nbsp;</div>
  	</div>
  </xsl:if>
  </xsl:if>
  
  <div id="content">
    <div id="framedivleft">
      <iframe onload="autoResize('thumbframe');"  src="pages/thumbnail/thumbnailpage1.html" align="center" width="100%" frameborder="0" id="thumbframe" name="leftframe" scrolling="auto"><xsl:text>&#09;</xsl:text></iframe>
    </div>
    <div id="framedivright">
      <iframe onload="autoResize('imageframe'); equalize();"  src="{/Doc/ImagePages/Page[1]/ImagePagePath}" align="right" width="100%" frameborder="0" id="imageframe" name="fullframe" scrolling="auto"><xsl:text>&#09;</xsl:text></iframe>
    </div>
    <div class="clearer">&nbsp;</div>
  </div>
  
  <xsl:if test="/Doc/IncludeFooter = 1">
  <xsl:if test="/Doc/Footer/UseInfo = 1">
  	<div id="pagefoot">
  		<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
    		<div class="left">
    			<xsl:if test="/Doc/Footer/Text[string(.)]">
    				<xsl:value-of select="Doc/Footer/Text"/>
    				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Author[string(.)]">
    				<xsl:value-of select="Doc/Footer/Author"/>
    				<xsl:if test="/Doc/Footer/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Date[string(.)]">
    				<xsl:value-of select="Doc/Footer/Date"/>
    			</xsl:if>
    		</div>
    	</xsl:if>
    	<xsl:if test="/Doc/Footer/Email[string(.)]">
    		<div class="right"><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="Doc/Footer/Email"/></a></div>
    	</xsl:if>
    	<div class="clearer">&nbsp;</div>
  	</div>
  </xsl:if>
  
  <xsl:if test="/Doc/Footer/UseImage = 1">
  	<div id="logofoot"><img src="{/Doc/Footer/ImagePath}"/></div>
  </xsl:if>
  </xsl:if>
</div>
</body>
</html>

</xsl:template>
</xsl:stylesheet>