<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="../../css/stylethumbs.css" rel="stylesheet" type="text/css" />
</head>
<body>
<table  border="0" cellpadding="0" cellspacing="0">
	<xsl:for-each select="Doc/ThumbnailPages/Page[1]/Item">
	  <tr align="center" valign="middle">
	    <td class="thumbtable">
	    	<div class="thumbcontainer">
	    		<a href="../../{ImagePagePath}" target="fullframe"><img src="../../{ThumbnailPath}" border="0" width="{ThumbnailWidth}" height="{ThumbnailHeight}"/></a>
	        <xsl:if test="ThumbnailTags[node()]">
		        <div class="thumbmeta">
		          <xsl:if test="ThumbnailTags/FileName/Value[string(.)]">
		            <strong><xsl:value-of select="ThumbnailTags/FileName/Value"/></strong><br/>
			  		  </xsl:if>
							<xsl:if test="ThumbnailTags/Date/Value[string(.)]">
								<xsl:value-of select="ThumbnailTags/Date/Value"/><br/>
							</xsl:if>
							<xsl:if test="ThumbnailTags/Rating">
								<xsl:if test="ThumbnailTags/Rating/Value = 0">
			        		<img src="../../resources/graf_star_zero.gif"/>
			        	</xsl:if>
			        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
			        		<img src="../../resources/graf_star_one.gif"/>
			        	</xsl:if>
			        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
			        		<img src="../../resources/graf_star_two.gif"/>
			        	</xsl:if>
			        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
			        		<img src="../../resources/graf_star_three.gif"/>
			        	</xsl:if>
			        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
			        		<img src="../../resources/graf_star_four.gif"/>
			        	</xsl:if>
			        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
			        		<img src="../../resources/graf_star_five.gif"/>
			        	</xsl:if>
								<br/>
			  		  </xsl:if>
			  		  <xsl:if test="ThumbnailTags/Tag and ThumbnailTags/Tag/Value[string(.)]">
			  		  <xsl:for-each select="ThumbnailTags/Tag">
			  		  	<xsl:if test="Value[string(.)]">
			  		  		<xsl:value-of select="Name"/>&nbsp; : &nbsp;<xsl:value-of select="Value"/><br/>
			  		    </xsl:if>
		        	</xsl:for-each>
		        	</xsl:if>
		      	</div>
		      </xsl:if>
	      </div>
	  	</td>
	  </tr>
	</xsl:for-each>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>