<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    <!ENTITY laquo "&#171;">   <!-- << -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
    
<xsl:param name="ImagePageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
<script language="JavaScript1.1">
		var playing = 0
		var timeoutID = 0
		var slideShowNextLink = "<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix"/><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/NextSlideshowImagePagePath"/>"
		var slideShowDelay = <xsl:value-of select="/Doc/SlideshowDelay"/>

		// Browser detection	
		var agt = navigator.userAgent.toLowerCase();
		var is_ie = (agt.indexOf("msie") != -1);

		if (location.href.indexOf("?") != -1) {
			urlQuery = location.href.split("?")
			playing = parseInt(urlQuery[1])
		}
		
		if (playing == 1) {
			startSlideShow()
		}
	
		function slideShow() {
			window.location.href = slideShowNextLink + "?" + "1"
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function startSlideShow() {
			clearTimeout(timeoutID)
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function stopSlideShow() {
			clearTimeout(timeoutID)
			if (is_ie) {
				fakeTimeoutID = setInterval("redirectDelay()", 0);
			}
			else {
				redirectDelay();
			}
		}
		
		function redirectDelay() {
			tempArray = window.location.href.split("?")
			window.location.href = tempArray[0]
		}
</script>
</head>
<body>
<table width="100%"  border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td align="center" valign="middle">
    	<table width="760" border="0" cellspacing="0" cellpadding="0">
	    	<tr>
	      	<td align="center" valign="middle">
	      		<div id="wrapper">
		        	<xsl:if test="/Doc/IncludeHeader = 1">
						  <xsl:if test="/Doc/Header/UseImage = 1">
						  	<div id="logohead"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Header/ImagePath}"/></div>
						  </xsl:if>
						  </xsl:if>
		          
		          <xsl:if test="/Doc/TitleBarText[string(.)]">
							<div id="pagehead">
								<h1><xsl:value-of select="Doc/TitleBarText"/></h1>
							</div>
							</xsl:if>
		          		          
		          <xsl:if test="/Doc/IncludeHeader = 1">
		          <xsl:if test="/Doc/Header/UseInfo = 1">
						  	<div id="subhead">
						  		<xsl:if test="/Doc/Header/Text[string(.)] or /Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
						    		<div class="left">
						    			<xsl:if test="/Doc/Header/Text[string(.)]">
						    				<xsl:value-of select="Doc/Header/Text"/>
						    				<xsl:if test="/Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Header/Author[string(.)]">
						    				<xsl:value-of select="Doc/Header/Author"/>
						    				<xsl:if test="/Doc/Header/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Header/Date[string(.)]">
						    				<xsl:value-of select="Doc/Header/Date"/>
						    			</xsl:if>
						    		</div>
						    	</xsl:if>
						    	<xsl:if test="/Doc/Header/Email[string(.)]">
						    		<div class="right"><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></div>
						    	</xsl:if>
						    	<div class="clearer">&nbsp;</div>
						  	</div>
						  </xsl:if>
						  </xsl:if>
		          
		          <div id="mainbox">
		          	<div class="imagenav">
		            	<div class="left"><xsl:value-of select="/Doc/Translations/Slideshow"/>:&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="startSlideShow()"><xsl:value-of select="/Doc/Translations/Start"/></a>&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="stopSlideShow()"><xsl:value-of select="/Doc/Translations/Stop"/></a></div>
						  		<div class="right">
						  			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[string(.)]">
											<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath}">&laquo;</a>&nbsp;&nbsp;
										</xsl:if>
										<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[.='']">
											<span class="this-page">&laquo;</span>&nbsp;&nbsp;
										</xsl:if>
										<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/HomeFileName}"><xsl:value-of select="/Doc/Translations/Home"/></a>&nbsp;&nbsp;
						  			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[string(.)]">
											<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath}">&raquo;</a>
							 			</xsl:if>
							 			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[.='']">
							 				<span class="this-page">&raquo;</span>
							 			</xsl:if>
		            	</div>
		            	<div class="clearer">&nbsp;</div>
		            </div>
		            
		            <div id="mainimage">
									<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[string(.)]">
							  		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/></a>
							  	</xsl:if>
							  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[.='']">
							  		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/>
							  	</xsl:if>
		            </div>
		            
								<table width="100%"  border="0" cellspacing="0" cellpadding="0">
		  						<tr>
		    						<td class="thumbtable">
		  								<div class="metatitle">
		  									<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)]">
								      		<h2 class="metatitle1"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value"/></h2>
								      	</xsl:if>
		  									<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
								        	<span class="metatitle2"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value"/></span>
								        </xsl:if>
								        <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
												  <xsl:choose>
													  <xsl:when test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
													  <span class="metatitle3">
													  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
											      	</xsl:if>
												  	</span>
												  	</xsl:when>
												  	<xsl:otherwise>
													  <span class="metatitle4">
													  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
											      	</xsl:if>
											      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
											      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
											      	</xsl:if>
												  	</span>
												  	</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
		          					<div class="clearer">&nbsp;</div>
		  								</div>
		  								
		  								<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
									      <div class="metabox">
									      <table cellspacing="0">
									      	<xsl:for-each select="Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
									      		<tr><td width="70%"><div class="metaitem"><strong><xsl:value-of select="Name"/></strong>&nbsp;&nbsp;</div></td><td><div class="metaitem"><xsl:value-of select="Value"/></div></td></tr>
									      	</xsl:for-each>
									      </table>
												</div>
											</xsl:if>
										</td>
		  						</tr>
								</table>
							</div>
		          
			        <xsl:if test="/Doc/IncludeFooter = 1">
		          <xsl:if test="/Doc/Footer/UseInfo = 1">
						  	<div id="subfoot">
						  		<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						    		<div class="left">
						    			<xsl:if test="/Doc/Footer/Text[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Text"/>
						    				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Footer/Author[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Author"/>
						    				<xsl:if test="/Doc/Footer/Date[string(.)]">
						    				&nbsp;|&nbsp;
						    				</xsl:if>
						    			</xsl:if>
						    			<xsl:if test="/Doc/Footer/Date[string(.)]">
						    				<xsl:value-of select="Doc/Footer/Date"/>
						    			</xsl:if>
						    		</div>
						    	</xsl:if>
						    	<xsl:if test="/Doc/Footer/Email[string(.)]">
						    		<div class="right"><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="Doc/Footer/Email"/></a></div>
						    	</xsl:if>
						    	<div class="clearer">&nbsp;</div>
						  	</div>
						  </xsl:if>
						  			        
			        <xsl:if test="/Doc/Footer/UseImage = 1">
						  	<div id="logofoot"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
						  </xsl:if>
						  </xsl:if>
		          
						</div>
					</td>
				</tr>
			</table>
		</td>
  </tr>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>