<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	color: #000000;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	padding: 0;
	margin: 0;
	width: 760px;
}

#content {
	width: 740px;
	padding: 10px;
	text-align: left;
	background: transparent;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
}

#logofoot {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
	padding: 7px;
	margin-bottom: 10px;
	line-height: 10pt;
	border: 1px solid #<xsl:value-of select="Doc/Colors/HeaderBorderColor/ColorValue"/>;
}

#pagehead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#subhead {
	margin: 0 0 10px 0;
}

#pagefoot {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	margin: 10px 0 30px 0;
	padding: 0 5px;
	float: left;
}

#pagefoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#mainimage {
	text-align: center;
	padding: 0 10px 10px 10px;
}

#framedivleft {
	background: transparent;
	width: 290px;
	float: left;
	overflow: auto;

}

#framedivright {
	background: transparent;
	width: 450px;
	float: right;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.sep {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 0;
	padding: 0;
}

.seppad {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 10px 0 10px 0;
	padding: 0;
}

.pagebar {
	margin: 10px 0;
}

.metabox {
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	border: #<xsl:value-of select="Doc/Colors/ImageMetadataBorderColor/ColorValue"/> 1px solid ;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
	padding: 5px;
	margin: 0;
	line-height: 11pt;
}

.metaitem {
	margin-bottom: 4px;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: <xsl:value-of select="Doc/Fonts/FilenameFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/FilenameFont/ColorValue"/>;
	line-height: 17pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FilenameFont/Family"/>&quot;, Helvetica, sans-serif;
	float: left;
	margin-right: 8px;
}

.metatitle2 {
	font-style: italic;
	margin-left: 2px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	margin-top: 0.5em;
	float: right;
}

.metatitle4 {
	margin-top: 0.5em;
	float: left;
}

.thumbcontainer {
	padding: 5px;
	margin: 5px;
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	border: #<xsl:value-of select="Doc/Colors/ThumbnailBorderColor/ColorValue"/> 1px solid;
	height: auto;
}

.thumbmeta {
	margin-top: 5px;
	text-align: left;
	line-height: 12pt;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
}

.paginate {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/PaginationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	padding-top: 5px;
	padding-bottom: 5px;
	margin: 0px;
	text-align: center;
}

.paginate a {
	padding: 2px;
	text-decoration: underline;
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
}

.paginate .this-page {
	padding: 2px;
	font-weight: bold;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
}

.paginate a:hover {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	text-decoration: none;
}

.imagenav {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	padding: 5px;
	margin: 10px 0 10px 0;
}

.imagenav a {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	margin: 10px 0 10px 0;
	font-weight: normal;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Times, serif;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
}

#subhead h1 {
	margin: 10px 0 0 0;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

</xsl:template>
</xsl:stylesheet>