<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    <!ENTITY laquo "&#171;">   <!-- << -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
    
<xsl:param name="ImagePageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
<script language="JavaScript1.1">
		var playing = 0
		var timeoutID = 0
		var slideShowNextLink = "<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix"/><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/NextSlideshowImagePagePath"/>"
		var slideShowDelay = <xsl:value-of select="/Doc/SlideshowDelay"/>

		// Browser detection	
		var agt = navigator.userAgent.toLowerCase();
		var is_ie = (agt.indexOf("msie") != -1);

		if (location.href.indexOf("?") != -1) {
			urlQuery = location.href.split("?")
			playing = parseInt(urlQuery[1])
		}
		
		if (playing == 1) {
			startSlideShow()
		}
	
		function slideShow() {
			window.location.href = slideShowNextLink + "?" + "1"
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function startSlideShow() {
			clearTimeout(timeoutID)
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function stopSlideShow() {
			clearTimeout(timeoutID)
			if (is_ie) {
				fakeTimeoutID = setInterval("redirectDelay()", 0);
			}
			else {
				redirectDelay();
			}
		}
		
		function redirectDelay() {
			tempArray = window.location.href.split("?")
			window.location.href = tempArray[0]
		}
</script>
</head>
<body>
  <div class="imagenav">
  	<strong><xsl:value-of select="/Doc/Translations/Slideshow"/>:</strong>&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="startSlideShow()"><xsl:value-of select="/Doc/Translations/Start"/></a>&nbsp;|&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="stopSlideShow()"><xsl:value-of select="/Doc/Translations/Stop"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[string(.)]">
			<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath}"><xsl:value-of select="/Doc/Translations/Previous"/></a>&nbsp;|&nbsp;
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[.='']">
			<xsl:value-of select="/Doc/Translations/Previous"/>&nbsp;|&nbsp;
		</xsl:if>
		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[1]/ImagePagePath}"><xsl:value-of select="/Doc/Translations/Home"/></a>&nbsp;|&nbsp;
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[string(.)]">
			<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath}"><xsl:value-of select="/Doc/Translations/Next"/></a>
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[.='']">
			<xsl:value-of select="/Doc/Translations/Next"/>
		</xsl:if>
 		<div class="clearer">&nbsp;</div>
  </div>
  
  <div id="mainimage">
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[string(.)]">
	  	<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath}" target="_top"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/></a>
	  </xsl:if>
	  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[.='']">
	  	<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/>
	  </xsl:if>
	</div>
	
	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags[node()]">
		<div class="metabox">
			<div class="metaitem">
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)]">
			  	<h2 class="metatitle1"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value"/></h2>
			  </xsl:if>
			  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
					<span class="metatitle2"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value"/></span>
			  </xsl:if>
			  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
				  <xsl:choose>
					  <xsl:when test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
					  <span class="metatitle3">
					  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
			      	</xsl:if>
				  	</span>
				  	</xsl:when>
				  	<xsl:otherwise>
					  <span class="metatitle4">
					  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
			      	</xsl:if>
				  	</span>
				  	</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
					<br/><br/>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
			  <table>
				  <xsl:for-each select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
				  	<tr><td width="70%"><div class="metaitem"><strong><xsl:value-of select="Name"/></strong></div></td><td><div class="metaitem"><xsl:value-of select="Value"/></div></td></tr>
					</xsl:for-each>
				</table>
				</xsl:if>
			</div>
		</div>
	</xsl:if>
</body>
</html>

</xsl:template>
</xsl:stylesheet>