<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:param name="ThumbnailPageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
</head>
<body>

  <table border="0" cellspacing="0" cellpadding="0">
  	<xsl:for-each select="Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/Row">
	  	<tr>
	    	<xsl:for-each select="Column">
		    	<td align="center" valign="middle">
		    		<table  border="0" cellspacing="0" cellpadding="0">
		      		<tr>
		        		<td align="center" valign="middle">
		        			<div class="thumbcontainer">
		        				<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ImagePagePath}" target="fullframe"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPath}" border="0" width="{ThumbnailWidth}" height="{ThumbnailHeight}"/></a>
		              	<xsl:if test="ThumbnailTags[node()]">
			              	<div class="thumbmeta">
			              		<xsl:if test="ThumbnailTags/FileName/Value[string(.)]">
			              			<p><strong><xsl:value-of select="ThumbnailTags/FileName/Value"/></strong></p>
			              		</xsl:if>
			              		<xsl:if test="ThumbnailTags/Date/Value[string(.)]">
			        						<p><xsl:value-of select="ThumbnailTags/Date/Value"/></p>
			        					</xsl:if>
			        					<xsl:if test="ThumbnailTags/Rating">
								  		  	<xsl:if test="ThumbnailTags/Rating/Value = 0">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_zero.gif"/>
								        	</xsl:if>
								        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_one.gif"/>
								        	</xsl:if>
								        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_two.gif"/>
								        	</xsl:if>
								        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_three.gif"/>
								        	</xsl:if>
								        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_four.gif"/>
								        	</xsl:if>
								        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
								        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_five.gif"/>
								        	</xsl:if>
								  		  	<br/>
								  		  </xsl:if>
								  		  <xsl:for-each select="ThumbnailTags/Tag">
			        						<p><em><xsl:value-of select="Name"/>&nbsp; : &nbsp;</em><xsl:value-of select="Value"/></p>
			        					</xsl:for-each>
			              	</div>
			              </xsl:if>
		            	</div>
		          	</td>
		        	</tr>
		      	</table>
		      </td>
		  	</xsl:for-each>
			</tr>
		</xsl:for-each>

    <tr>
    	<td colspan="2" align="center" valign="middle">
    		<div class="paginate"> <xsl:value-of select="/Doc/Translations/Pages"/>:&nbsp;&nbsp;&nbsp;&nbsp; 
	    		<xsl:for-each select="Doc/ThumbnailPages/Page">
				  	<xsl:if test="CurrentThumbnailPageNumber = $ThumbnailPageStartItem">
				  		<span class="this-page"><xsl:value-of select="CurrentThumbnailPageNumber"/></span>
				  	</xsl:if>
				  	<xsl:if test="CurrentThumbnailPageNumber != $ThumbnailPageStartItem">
				  		<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPagePath}"><xsl:value-of select="CurrentThumbnailPageNumber"/></a>
				  	</xsl:if>
				  </xsl:for-each>
    		</div>
    	</td>
    </tr>
	</table>
	
</body>
</html>

</xsl:template>
</xsl:stylesheet>